/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.stream.Stream;

public class FilesUtils {
    public static void deleteIfExists(Path path) {
        if (path == null) {
            return;
        }
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteRecursively(Path path) {
        if (path == null) {
            return;
        }
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder());){
            stream.forEach(toDelete -> {
                if (toDelete.startsWith(path)) {
                    FilesUtils.deleteIfExists(toDelete);
                }
            });
        }
        catch (IOException iOException) {
        }
        finally {
            FilesUtils.deleteIfExists(path);
        }
    }
}

