/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.killbill.billing.osgi.bundles.kpm.KPMPluginException;
import org.killbill.billing.osgi.bundles.kpm.KpmProperties;
import org.killbill.billing.osgi.bundles.kpm.PluginIdentifiersDAO;
import org.killbill.billing.osgi.bundles.kpm.impl.PluginNamingResolver;
import org.killbill.commons.utils.Preconditions;
import org.killbill.commons.utils.Strings;
import org.killbill.commons.utils.annotation.VisibleForTesting;

class FileBasedPluginIdentifiersDAO
implements PluginIdentifiersDAO {
    private static final String FILE_NAME = "plugin_identifiers.json";
    private final ObjectMapper objectMapper = new ObjectMapper();
    @VisibleForTesting
    final File file;

    public FileBasedPluginIdentifiersDAO(KpmProperties kpmProperties) {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        Path bundlesPath = kpmProperties.getBundlesPath();
        Path directory = Path.of(bundlesPath.toString(), "plugins");
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
            this.file = Path.of(directory.toString(), FILE_NAME).toFile();
            if (this.file.createNewFile()) {
                this.objectMapper.writeValue(this.file, Collections.emptyMap());
            }
        }
        catch (IOException e) {
            throw new KPMPluginException(e);
        }
    }

    @VisibleForTesting
    Map<String, PluginIdentifiersDAO.PluginIdentifierModel> loadFileContent() {
        try {
            return this.objectMapper.readValue(this.file, new TypeReference<Map<String, PluginIdentifiersDAO.PluginIdentifierModel>>(){});
        }
        catch (IOException e) {
            throw new KPMPluginException(String.format("Cannot load %s content", this.file), e);
        }
    }

    @VisibleForTesting
    void writeContentToFile(Map<String, PluginIdentifiersDAO.PluginIdentifierModel> contents) {
        try {
            this.objectMapper.writeValue(this.file, contents);
        }
        catch (IOException e) {
            throw new KPMPluginException(String.format("Cannot write to %s. Content value: %s", this.file, contents.toString()), e);
        }
    }

    @Override
    public void add(String pluginKey, String version) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(pluginKey), "'pluginKey' cannot be null or empty", new Object[0]);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(version), "'version' cannot be null or empty", new Object[0]);
        PluginNamingResolver namingResolver = PluginNamingResolver.of(pluginKey, version);
        Map<String, PluginIdentifiersDAO.PluginIdentifierModel> content = this.loadFileContent();
        content.put(pluginKey, new PluginIdentifiersDAO.PluginIdentifierModel(namingResolver.getPluginName(), namingResolver.getPluginVersion()));
        this.writeContentToFile(content);
    }

    @Override
    public void add(String pluginKey, String groupId, String artifactId, String version) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(pluginKey), "'pluginKey' cannot be null or empty", new Object[0]);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(groupId), "'groupId' cannot be null or empty", new Object[0]);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(artifactId), "'artifactId' cannot be null or empty", new Object[0]);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(version), "'version' cannot be null or empty", new Object[0]);
        PluginNamingResolver namingResolver = PluginNamingResolver.of(pluginKey, version);
        Map<String, PluginIdentifiersDAO.PluginIdentifierModel> content = this.loadFileContent();
        PluginIdentifiersDAO.PluginIdentifierModel model = new PluginIdentifiersDAO.PluginIdentifierModel(namingResolver.getPluginName(), groupId, artifactId, namingResolver.getPluginVersion());
        content.put(pluginKey, model);
        this.writeContentToFile(content);
    }

    @Override
    public void remove(String pluginKey) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(pluginKey), "'pluginKey' cannot be null or empty", new Object[0]);
        Map<String, PluginIdentifiersDAO.PluginIdentifierModel> content = this.loadFileContent();
        content.remove(pluginKey);
        this.writeContentToFile(content);
    }

    @Override
    public Set<PluginIdentifiersDAO.PluginIdentifiersModel> getPluginIdentifiers() {
        return this.loadFileContent().entrySet().stream().map(entry -> new PluginIdentifiersDAO.PluginIdentifiersModel((String)entry.getKey(), (PluginIdentifiersDAO.PluginIdentifierModel)entry.getValue())).collect(Collectors.toUnmodifiableSet());
    }
}

