/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.nio.file.Path;
import org.killbill.billing.osgi.bundles.kpm.VersionsProvider;
import org.killbill.billing.osgi.bundles.kpm.impl.XmlParser;
import org.killbill.billing.util.nodes.NodeInfo;
import org.killbill.commons.utils.Preconditions;

class DefaultVersionsProvider
implements VersionsProvider {
    private final String fixedKbVersion;
    private final String ossParentVersion;
    private final String apiVersion;
    private final String pluginApiVersion;
    private final String commonsVersion;
    private final String platformVersion;

    DefaultVersionsProvider(Path killbillPomXml, Path ossParentPomXml) throws Exception {
        XmlParser killbillPomParser = new XmlParser(Preconditions.checkNotNull(killbillPomXml));
        XmlParser ossParentPomParser = new XmlParser(Preconditions.checkNotNull(ossParentPomXml));
        this.fixedKbVersion = killbillPomParser.getValue("/version");
        this.ossParentVersion = killbillPomParser.getValue("/parent/version");
        this.apiVersion = ossParentPomParser.getValue("/properties/killbill-api.version");
        this.pluginApiVersion = ossParentPomParser.getValue("/properties/killbill-plugin-api.version");
        this.commonsVersion = ossParentPomParser.getValue("/properties/killbill-commons.version");
        this.platformVersion = ossParentPomParser.getValue("/properties/killbill-platform.version");
    }

    DefaultVersionsProvider(Path killbillPomXml, NodeInfo nodeInfo) throws Exception {
        Preconditions.checkNotNull(killbillPomXml, "'killbillPomXml' is null");
        Preconditions.checkNotNull(nodeInfo, "'nodeInfo' is null");
        XmlParser killbillPomParser = new XmlParser(killbillPomXml);
        this.fixedKbVersion = killbillPomParser.getValue("/version");
        this.ossParentVersion = killbillPomParser.getValue("/parent/version");
        this.apiVersion = nodeInfo.getApiVersion();
        this.pluginApiVersion = nodeInfo.getPluginApiVersion();
        this.commonsVersion = nodeInfo.getCommonVersion();
        this.platformVersion = nodeInfo.getPlatformVersion();
    }

    @Override
    public String getFixedKillbillVersion() {
        return this.fixedKbVersion;
    }

    @Override
    public String getOssParentVersion() {
        return this.ossParentVersion;
    }

    @Override
    public String getKillbillApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getKillbillPluginApiVersion() {
        return this.pluginApiVersion;
    }

    @Override
    public String getKillbillCommonsVersion() {
        return this.commonsVersion;
    }

    @Override
    public String getKillbillPlatformVersion() {
        return this.platformVersion;
    }
}

