/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.killbill.billing.osgi.bundles.kpm.KPMClient;
import org.killbill.billing.osgi.bundles.kpm.KPMPluginException;
import org.killbill.billing.osgi.bundles.kpm.PluginsDirectoryDAO;
import org.killbill.billing.osgi.bundles.kpm.UriResolver;
import org.killbill.billing.osgi.bundles.kpm.impl.FilesUtils;
import org.killbill.billing.osgi.bundles.kpm.impl.YamlParser;
import org.killbill.commons.utils.Strings;

class DefaultPluginsDirectoryDAO
implements PluginsDirectoryDAO {
    private final KPMClient httpClient;
    private final String killbillVersion;
    private final UriResolver uriResolver;

    DefaultPluginsDirectoryDAO(KPMClient httpClient, UriResolver uriResolver, String semverBasedKbVersion) {
        this.httpClient = httpClient;
        this.uriResolver = uriResolver;
        this.killbillVersion = semverBasedKbVersion;
    }

    @Override
    public Set<PluginsDirectoryDAO.PluginsDirectoryModel> getPlugins() throws KPMPluginException {
        HashSet<PluginsDirectoryDAO.PluginsDirectoryModel> result = new HashSet<PluginsDirectoryDAO.PluginsDirectoryModel>();
        Path downloadedPluginDirPath = this.downloadPluginDirectory();
        YamlParser yamlParser = new YamlParser(downloadedPluginDirPath);
        Set<Object> yamlData = yamlParser.loadAll();
        if (yamlData == null || yamlData.isEmpty()) {
            FilesUtils.deleteIfExists(downloadedPluginDirPath);
            return Collections.emptySet();
        }
        this.mapYamlDataToModel(yamlData, result);
        FilesUtils.deleteIfExists(downloadedPluginDirPath);
        return result;
    }

    Path downloadPluginDirectory() {
        String[] fileNameAndExt = new String[]{"plugins_directory", ".yml"};
        try {
            return this.httpClient.downloadToTempOS(this.uriResolver.getBaseUri(), this.uriResolver.getHeaders(), fileNameAndExt);
        }
        catch (Exception e) {
            throw new KPMPluginException(String.format("Cannot get plugin directory YAML from URL: %s", this.uriResolver.getBaseUri()), e);
        }
    }

    void mapYamlDataToModel(Iterable<Object> yamlData, Collection<PluginsDirectoryDAO.PluginsDirectoryModel> result) {
        yamlData.forEach(allData -> {
            Map root = (Map)allData;
            for (Map.Entry node : root.entrySet()) {
                String pluginKey = ((String)node.getKey()).replace(":", "");
                Object value = node.getValue();
                if (!(value instanceof Map)) continue;
                Map typeVersionsTree = (Map)value;
                Map versions = (Map)typeVersionsTree.get(":versions");
                Object artifactId = typeVersionsTree.get(":artifact_id");
                for (Map.Entry versionEntry : versions.entrySet()) {
                    String compatibleKbVersion = ((String)versionEntry.getKey()).replace(":", "");
                    if (!this.killbillVersion.startsWith(compatibleKbVersion)) continue;
                    PluginsDirectoryDAO.PluginsDirectoryModel model = new PluginsDirectoryDAO.PluginsDirectoryModel(pluginKey, (String)versionEntry.getValue());
                    if (artifactId != null && !Strings.isNullOrEmpty(artifactId.toString())) {
                        model.setPluginArtifactId(artifactId.toString());
                    }
                    result.add(model);
                }
            }
        });
    }
}

