/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.Set;
import javax.annotation.Nonnull;
import org.killbill.billing.osgi.api.OSGIKillbill;
import org.killbill.billing.osgi.api.PluginStateChange;
import org.killbill.billing.osgi.bundles.kpm.KPMClient;
import org.killbill.billing.osgi.bundles.kpm.KPMPluginException;
import org.killbill.billing.osgi.bundles.kpm.KpmProperties;
import org.killbill.billing.osgi.bundles.kpm.PluginFileService;
import org.killbill.billing.osgi.bundles.kpm.PluginIdentifiersDAO;
import org.killbill.billing.osgi.bundles.kpm.PluginInstaller;
import org.killbill.billing.osgi.bundles.kpm.PluginManager;
import org.killbill.billing.osgi.bundles.kpm.PluginsDirectoryDAO;
import org.killbill.billing.osgi.bundles.kpm.UriResolver;
import org.killbill.billing.osgi.bundles.kpm.VersionsProvider;
import org.killbill.billing.osgi.bundles.kpm.impl.ArtifactAndVersionFinder;
import org.killbill.billing.osgi.bundles.kpm.impl.AvailablePluginsComponentsFactory;
import org.killbill.billing.osgi.bundles.kpm.impl.CoordinateBasedPluginDownloader;
import org.killbill.billing.osgi.bundles.kpm.impl.DefaultPluginFileService;
import org.killbill.billing.osgi.bundles.kpm.impl.DefaultPluginInstaller;
import org.killbill.billing.osgi.bundles.kpm.impl.FileBasedPluginIdentifiersDAO;
import org.killbill.billing.osgi.bundles.kpm.impl.FilesUtils;
import org.killbill.billing.osgi.bundles.kpm.impl.PluginNamingResolver;
import org.killbill.billing.osgi.bundles.kpm.impl.UrlResolverFactory;
import org.killbill.billing.osgi.libs.killbill.OSGIKillbillAPI;
import org.killbill.commons.utils.Strings;
import org.killbill.commons.utils.annotation.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginManager
implements PluginManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPluginManager.class);
    private final OSGIKillbillAPI killbillApi;
    private final KPMClient httpClient;
    private final PluginIdentifiersDAO pluginIdentifiersDAO;
    private final AvailablePluginsComponentsFactory availablePluginsComponentsFactory;
    private final CoordinateBasedPluginDownloader pluginDownloader;
    private final UrlResolverFactory urlResolverFactory;
    private final PluginInstaller pluginInstaller;
    private final String adminUsername;
    private final String adminPassword;

    public DefaultPluginManager(@Nonnull OSGIKillbillAPI killbillApi, @Nonnull KpmProperties kpmProperties) {
        this.killbillApi = killbillApi;
        this.urlResolverFactory = new UrlResolverFactory(kpmProperties);
        this.pluginIdentifiersDAO = this.createPluginIdentifiersDAO(kpmProperties);
        this.httpClient = this.createHttpClient(kpmProperties);
        this.availablePluginsComponentsFactory = new AvailablePluginsComponentsFactory((OSGIKillbill)killbillApi, this.httpClient, kpmProperties);
        this.pluginDownloader = this.createCoordinateBasedPluginDownloader(kpmProperties);
        this.pluginInstaller = new DefaultPluginInstaller(new DefaultPluginFileService(kpmProperties));
        this.adminUsername = kpmProperties.getKillbillAdminUsername();
        this.adminPassword = kpmProperties.getKillbillAdminPassword();
    }

    @VisibleForTesting
    PluginIdentifiersDAO createPluginIdentifiersDAO(KpmProperties kpmProperties) {
        return new FileBasedPluginIdentifiersDAO(kpmProperties);
    }

    @VisibleForTesting
    KPMClient createHttpClient(KpmProperties kpmProperties) {
        try {
            return new KPMClient(kpmProperties.isStrictSSL(), kpmProperties.getConnectTimeoutSec() * 1000, kpmProperties.getReadTimeoutSec() * 1000);
        }
        catch (GeneralSecurityException e) {
            throw new KPMPluginException("Cannot create KpmHttpClient, there's problem with SSL context creation.", e);
        }
    }

    CoordinateBasedPluginDownloader createCoordinateBasedPluginDownloader(KpmProperties kpmProperties) {
        ArtifactAndVersionFinder finder = new ArtifactAndVersionFinder(this.pluginIdentifiersDAO, this.availablePluginsComponentsFactory);
        UriResolver uriResolver = this.urlResolverFactory.getCoordinateBasedPluginDownloaderUrlResolver();
        boolean verifySSH = kpmProperties.pluginsInstall().coordinate().isVerifySHA1();
        boolean alwaysTryPublicRepo = kpmProperties.pluginsInstall().coordinate().isAlwaysTryPublicRepository();
        return new CoordinateBasedPluginDownloader(this.httpClient, finder, uriResolver, verifySSH, alwaysTryPublicRepo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFileSystemChange(PluginStateChange newState, String pluginKey, String pluginVersion) {
        try {
            logger.info("Notifying Kill Bill: state='{}', pluginKey='{}', pluginVersion={}", new Object[]{newState, pluginKey, pluginVersion});
            this.killbillApi.getSecurityApi().login((Object)this.adminUsername, (Object)this.adminPassword);
            this.killbillApi.getPluginsInfoApi().notifyOfStateChanged(newState, pluginKey, null, pluginVersion, null);
        }
        finally {
            this.killbillApi.getSecurityApi().logout();
        }
    }

    @Override
    public PluginManager.GetAvailablePluginsModel getAvailablePlugins(@Nonnull String kbVersion, boolean forceDownload) throws KPMPluginException {
        PluginManager.GetAvailablePluginsModel result = new PluginManager.GetAvailablePluginsModel();
        VersionsProvider versionsProvider = this.availablePluginsComponentsFactory.createVersionsProvider(kbVersion, forceDownload);
        result.addKillbillVersion(versionsProvider.getFixedKillbillVersion());
        result.addOssParentVersion(versionsProvider.getOssParentVersion());
        result.addApiVersion(versionsProvider.getKillbillApiVersion());
        result.addPluginApiVersion(versionsProvider.getKillbillPluginApiVersion());
        result.addCommonsVersion(versionsProvider.getKillbillCommonsVersion());
        result.addPlatformVersion(versionsProvider.getKillbillPlatformVersion());
        Set<PluginsDirectoryDAO.PluginsDirectoryModel> plugins = this.availablePluginsComponentsFactory.createPluginsDirectoryDAO(versionsProvider.getFixedKillbillVersion(), forceDownload).getPlugins();
        plugins.forEach(entry -> result.addPlugins(entry.getPluginKey(), entry.getPluginVersion()));
        return result;
    }

    @Override
    public void install(@Nonnull String uri, @Nonnull String pluginKey, @Nonnull String pluginVersion) throws KPMPluginException {
        Path downloadDir;
        logger.debug("Installing plugin via URL for key: {}, pluginVersion: {}, uri: {}", new Object[]{pluginKey, pluginVersion, uri});
        Path downloadedFile = null;
        PluginNamingResolver namingResolver = PluginNamingResolver.of(pluginKey, pluginVersion, uri);
        try {
            Path downloadDirectory = PluginFileService.createTmpDownloadPath();
            String pluginFileName = namingResolver.getPluginJarFileName();
            String fixedVersion = namingResolver.getPluginVersion();
            downloadedFile = downloadDirectory.resolve(pluginFileName);
            this.httpClient.download(uri, downloadedFile);
            this.pluginInstaller.install(downloadedFile, pluginKey, fixedVersion);
            this.pluginIdentifiersDAO.add(pluginKey, fixedVersion);
            this.notifyFileSystemChange(PluginStateChange.NEW_VERSION, pluginKey, fixedVersion);
            downloadDir = downloadedFile == null ? null : downloadedFile.getParent();
        }
        catch (Exception e) {
            try {
                logger.error("Error when install plugin with URI:{}, key:{}, version:{}", new Object[]{uri, pluginKey, pluginVersion});
                throw new KPMPluginException(e);
            }
            catch (Throwable throwable) {
                Path downloadDir2 = downloadedFile == null ? null : downloadedFile.getParent();
                FilesUtils.deleteIfExists(downloadedFile);
                FilesUtils.deleteIfExists(downloadDir2);
                throw throwable;
            }
        }
        FilesUtils.deleteIfExists(downloadedFile);
        FilesUtils.deleteIfExists(downloadDir);
    }

    @Override
    public void install(@Nonnull String pluginKey, @Nonnull String kbVersion, String groupId, String artifactId, String pluginVersion, boolean forceDownload) throws KPMPluginException {
        logger.info("Install plugin via coordinate. key:{}, kbVersion:{}, version:{}, groupId:{}, artifactId:{}", new Object[]{pluginKey, kbVersion, pluginVersion, groupId, artifactId});
        CoordinateBasedPluginDownloader.DownloadResult downloadResult = null;
        Path installedPath = null;
        try {
            downloadResult = this.pluginDownloader.download(pluginKey, kbVersion, groupId, artifactId, pluginVersion, forceDownload);
            logger.debug("downloadResult object value: {}", (Object)downloadResult);
            Path downloadedPath = downloadResult.getDownloadedPath();
            groupId = downloadResult.getGroupId();
            artifactId = downloadResult.getArtifactId();
            pluginVersion = downloadResult.getPluginVersion();
            installedPath = this.pluginInstaller.install(downloadedPath, pluginKey, pluginVersion);
            this.pluginIdentifiersDAO.add(pluginKey, groupId, artifactId, pluginVersion);
            this.notifyFileSystemChange(PluginStateChange.NEW_VERSION, pluginKey, pluginVersion);
            logger.info("Plugin key: {} installed successfully via coordinate.", (Object)pluginKey);
        }
        catch (Exception e) {
            logger.error("Error when install pluginKey: '{}' with coordinate. Exception: {}", (Object)pluginKey, (Object)e.getMessage());
            FilesUtils.deleteIfExists(installedPath);
            throw new KPMPluginException(e);
        }
        finally {
            if (downloadResult != null && downloadResult.getDownloadedPath() != null) {
                FilesUtils.deleteRecursively(downloadResult.getDownloadedPath().getParent());
            }
        }
    }

    @Override
    public void uninstall(String pluginKey, String version) throws KPMPluginException {
        String nextPluginVersion;
        Path nextPluginByKey = this.pluginInstaller.uninstall(pluginKey, version);
        String string = nextPluginVersion = nextPluginByKey == null || nextPluginByKey.getFileName() == null ? null : PluginNamingResolver.getVersionFromString(nextPluginByKey.getFileName().toString());
        if (Strings.isNullOrEmpty(nextPluginVersion)) {
            this.pluginIdentifiersDAO.remove(pluginKey);
        } else {
            this.pluginIdentifiersDAO.add(pluginKey, nextPluginVersion);
        }
        this.notifyFileSystemChange(PluginStateChange.DISABLED, pluginKey, version);
    }
}

