/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.killbill.billing.osgi.bundles.kpm.KPMPluginException;
import org.killbill.billing.osgi.bundles.kpm.PluginFileService;
import org.killbill.billing.osgi.bundles.kpm.PluginInstaller;
import org.killbill.billing.osgi.bundles.kpm.impl.FilesUtils;
import org.killbill.billing.osgi.bundles.kpm.impl.PluginNamingResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultPluginInstaller
implements PluginInstaller {
    private final Logger logger = LoggerFactory.getLogger(DefaultPluginInstaller.class);
    private final PluginFileService pluginFileService;

    public DefaultPluginInstaller(PluginFileService pluginFileService) {
        this.pluginFileService = pluginFileService;
    }

    @Override
    public Path install(Path downloadedFile, String pluginKey, String pluginVersion) throws KPMPluginException {
        try {
            Path pluginDirectory = this.pluginFileService.createPluginDirectory(pluginKey, pluginVersion);
            Path result = Files.copy(downloadedFile, pluginDirectory.resolve(PluginNamingResolver.of(pluginKey, pluginVersion).getPluginJarFileName()), StandardCopyOption.REPLACE_EXISTING);
            this.pluginFileService.createSymlink(pluginDirectory);
            return result;
        }
        catch (IOException e) {
            throw new KPMPluginException(String.format("Unable to install plugin with key: %s", pluginKey), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Path uninstall(String pluginKey, String pluginVersion) throws KPMPluginException {
        try {
            PluginNamingResolver namingResolver = PluginNamingResolver.of(pluginKey, pluginVersion);
            Path pluginDirectory = this.pluginFileService.getPluginDirByPluginKeyAndVersion(pluginKey, pluginVersion);
            Path pluginFile = pluginDirectory.resolve(namingResolver.getPluginJarFileName());
            Path parentOfPluginDir = pluginDirectory.getParent();
            this.logger.debug("#uninstall() key{}-{}. Is Exists? dir:{}, file:{}", new Object[]{pluginKey, pluginVersion, Files.exists(pluginDirectory, new LinkOption[0]), Files.exists(pluginFile, new LinkOption[0])});
            FilesUtils.deleteRecursively(pluginDirectory);
            this.logger.debug("#uninstall() Is still exists after deleteRecursively()? dir: {}, file: {}", (Object)Files.exists(pluginDirectory, new LinkOption[0]), (Object)Files.exists(pluginFile, new LinkOption[0]));
            String symlinkName = "SET_DEFAULT";
            try (Stream<Path> stream = Files.list(parentOfPluginDir);){
                Set parentOfPluginDirSet = stream.collect(Collectors.toUnmodifiableSet());
                parentOfPluginDirSet.stream().filter(path -> path.getFileName().toString().equals("SET_DEFAULT")).forEach(FilesUtils::deleteIfExists);
                Path nextLatestPluginForKey = parentOfPluginDirSet.stream().filter(path -> !path.getFileName().toString().equals("SET_DEFAULT")).max(Comparator.naturalOrder()).orElse(null);
                this.logger.debug("nextLatestPluginForKey: {}", (Object)nextLatestPluginForKey);
                if (nextLatestPluginForKey != null) {
                    this.pluginFileService.createSymlink(nextLatestPluginForKey);
                    Path path2 = nextLatestPluginForKey;
                    return path2;
                }
                FilesUtils.deleteIfExists(parentOfPluginDir);
                return null;
            }
        }
        catch (IOException e) {
            String msg = String.format("Cannot uninstall: %s version: %s, because %s", pluginKey, pluginVersion, e.getMessage());
            throw new KPMPluginException(msg, e);
        }
    }
}

