/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nonnull;
import org.killbill.billing.osgi.bundles.kpm.KpmProperties;
import org.killbill.billing.osgi.bundles.kpm.PluginFileService;
import org.killbill.billing.osgi.bundles.kpm.impl.PluginNamingResolver;
import org.killbill.commons.utils.annotation.VisibleForTesting;

public class DefaultPluginFileService
implements PluginFileService {
    @VisibleForTesting
    static final String DEFAULT_SYMLINK_NAME = "SET_DEFAULT";
    private final Path bundlesPath;

    public DefaultPluginFileService(KpmProperties kpmProperties) {
        this.bundlesPath = kpmProperties.getBundlesPath();
    }

    @Override
    public Path createPluginDirectory(String pluginKey, String pluginVersion) throws IOException {
        Path pluginDirectory = this.getPluginDirByPluginKeyAndVersion(pluginKey, pluginVersion);
        return Files.createDirectories(pluginDirectory, new FileAttribute[0]);
    }

    @Override
    public void createSymlink(@Nonnull Path pluginDirectory) throws IOException {
        Path symlink = pluginDirectory.resolveSibling(DEFAULT_SYMLINK_NAME);
        Path parentDir = symlink.getParent();
        if (parentDir != null) {
            Files.createDirectories(parentDir, new FileAttribute[0]);
        }
        Files.deleteIfExists(symlink);
        Files.createSymbolicLink(symlink, pluginDirectory, new FileAttribute[0]);
    }

    @Override
    public Path getPluginDirByPluginKeyAndVersion(@Nonnull String pluginKey, @Nonnull String pluginVersion) {
        PluginNamingResolver pluginNamingResolver = PluginNamingResolver.of(pluginKey, pluginVersion);
        String pluginName = pluginNamingResolver.getPluginName();
        String fixedVersion = pluginNamingResolver.getPluginVersion();
        return Path.of(this.bundlesPath.toString(), "plugins", "java", pluginName, fixedVersion);
    }
}

