/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.nio.file.Path;
import org.killbill.billing.osgi.bundles.kpm.KPMClient;
import org.killbill.billing.osgi.bundles.kpm.NexusMetadataFiles;
import org.killbill.billing.osgi.bundles.kpm.UriResolver;
import org.killbill.billing.osgi.bundles.kpm.impl.FilesUtils;
import org.killbill.billing.osgi.bundles.kpm.impl.XmlParser;
import org.killbill.commons.utils.annotation.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultNexusMetadataFiles
implements NexusMetadataFiles {
    private final Logger logger = LoggerFactory.getLogger(DefaultNexusMetadataFiles.class);
    private final KPMClient httpClient;
    private final UriResolver uriResolver;
    private final String mavenMetadataXmlUrl;
    private final String killbillVersionOrLatest;
    protected Path killbillPomXml;
    protected Path ossParentPomXml;

    DefaultNexusMetadataFiles(KPMClient httpClient, UriResolver uriResolver, String mavenMetadataXmlUrl, String killbillVersionOrLatest) {
        this.httpClient = httpClient;
        this.uriResolver = uriResolver;
        this.mavenMetadataXmlUrl = mavenMetadataXmlUrl;
        this.killbillVersionOrLatest = killbillVersionOrLatest;
        this.logger.debug("Will get killbill info from sonatype repository with basePath:{}, and killbillVersion:{}", (Object)uriResolver.getBaseUri(), (Object)killbillVersionOrLatest);
    }

    @Override
    public Path getKillbillPomXml() throws Exception {
        if (this.killbillPomXml == null) {
            String killbillUrl = this.getKillbillUrl();
            this.killbillPomXml = this.httpClient.downloadToTempOS(killbillUrl, this.uriResolver.getHeaders(), "killbill-pom", ".pom");
            this.logger.debug("getKillbillPomXml() will download to: {} from killbillUrl:{}", (Object)this.killbillPomXml, (Object)killbillUrl);
        } else {
            this.logger.debug("getKillbillPomXml() is not null and the value is:{}", (Object)this.killbillPomXml);
        }
        return this.killbillPomXml;
    }

    @Override
    public Path getOssParentPomXml() throws Exception {
        if (this.ossParentPomXml == null) {
            if (this.killbillPomXml == null) {
                this.killbillPomXml = this.getKillbillPomXml();
            }
            this.ossParentPomXml = this.httpClient.downloadToTempOS(this.getOssParentUrl(), this.uriResolver.getHeaders(), "oss-parent-pom", ".pom");
        }
        return this.ossParentPomXml;
    }

    @Override
    public void cleanup() {
        FilesUtils.deleteIfExists(this.killbillPomXml);
        FilesUtils.deleteIfExists(this.ossParentPomXml);
    }

    @VisibleForTesting
    String getKillbillUrl() throws Exception {
        String actualKbVersion;
        if ("latest".equalsIgnoreCase(this.killbillVersionOrLatest)) {
            Path mavenMetadataXmlPath = this.getMavenMetadataXml();
            XmlParser mavenMetadataParser = new XmlParser(mavenMetadataXmlPath);
            actualKbVersion = mavenMetadataParser.getValue("/versioning/latest");
            FilesUtils.deleteIfExists(mavenMetadataXmlPath);
        } else {
            actualKbVersion = this.killbillVersionOrLatest;
        }
        return String.format("%s/org/kill-bill/billing/killbill/%s/killbill-%s.pom", this.uriResolver.getBaseUri(), actualKbVersion, actualKbVersion);
    }

    @VisibleForTesting
    Path getMavenMetadataXml() {
        String[] fileNameAndExt = new String[]{"maven-metadata", ".xml"};
        if (this.uriResolver.getAuthMethod() == UriResolver.AuthenticationMethod.NONE || this.mavenMetadataXmlUrl.contains("repo1.maven.org") || this.mavenMetadataXmlUrl.contains("oss.sonatype.org")) {
            return this.httpClient.downloadToTempOS(this.mavenMetadataXmlUrl, fileNameAndExt);
        }
        return this.httpClient.downloadToTempOS(this.mavenMetadataXmlUrl, this.uriResolver.getHeaders(), fileNameAndExt);
    }

    @VisibleForTesting
    String getOssParentUrl() throws Exception {
        if (this.killbillPomXml == null) {
            this.killbillPomXml = this.getKillbillPomXml();
        }
        XmlParser xmlParser = new XmlParser(this.killbillPomXml);
        String ossVersion = xmlParser.getValue("/parent/version");
        return String.format("%s/org/kill-bill/billing/killbill-oss-parent/%s/killbill-oss-parent-%s.pom", this.uriResolver.getBaseUri(), ossVersion, ossVersion);
    }
}

