/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.JarFile;
import org.killbill.billing.osgi.bundles.kpm.KPMClient;
import org.killbill.billing.osgi.bundles.kpm.KPMPluginException;
import org.killbill.billing.osgi.bundles.kpm.UriResolver;
import org.killbill.billing.osgi.bundles.kpm.impl.ArtifactAndVersionFinder;
import org.killbill.billing.osgi.bundles.kpm.impl.PluginNamingResolver;
import org.killbill.billing.osgi.bundles.kpm.impl.Sha1Checker;
import org.killbill.commons.utils.Preconditions;
import org.killbill.commons.utils.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CoordinateBasedPluginDownloader {
    private static final Logger logger = LoggerFactory.getLogger(CoordinateBasedPluginDownloader.class);
    private static final String KILLBILL_GROUP_ID = "org.kill-bill.billing.plugin.java";
    private static final String SONATYPE_RELEASE_URL = "https://oss.sonatype.org/content/repositories/releases/";
    private final KPMClient httpClient;
    private final Sha1Checker sha1Checker;
    private final ArtifactAndVersionFinder artifactAndVersionFinder;
    private final UriResolver uriResolver;
    private final boolean shouldTryPublicRepository;

    CoordinateBasedPluginDownloader(KPMClient httpClient, ArtifactAndVersionFinder artifactAndVersionFinder, UriResolver uriResolver, boolean shouldVerify, boolean shouldTryPublicRepository) {
        this.httpClient = httpClient;
        this.artifactAndVersionFinder = artifactAndVersionFinder;
        this.uriResolver = uriResolver;
        this.sha1Checker = new Sha1Checker(httpClient, shouldVerify);
        this.shouldTryPublicRepository = shouldTryPublicRepository;
    }

    DownloadResult download(String pluginKey, String killbillVersion, String pluginGroupId, String pluginArtifactId, String pluginVersion, boolean forceDownload) throws KPMPluginException {
        String actualPluginVersion;
        String actualArtifactId;
        Preconditions.checkArgument(!Strings.isNullOrEmpty(pluginKey), "'pluginKey' is null or empty.", new Object[0]);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(killbillVersion), "'killbillVersion' is null or empty.", new Object[0]);
        Preconditions.checkArgument(!"latest".equalsIgnoreCase(killbillVersion), "PluginDownloader not accepting 'latest' killbill version", new Object[0]);
        Optional<ArtifactAndVersionFinder.ArtifactAndVersionModel> artifactAndVersionOpt = this.artifactAndVersionFinder.findArtifactAndVersion(killbillVersion, pluginKey, pluginArtifactId, pluginVersion, forceDownload);
        if (artifactAndVersionOpt.isEmpty()) {
            throw new KPMPluginException("Unable to find 'pluginArtifactId' and/or 'pluginVersion'. This is required when install plugin via coordinate");
        }
        ArtifactAndVersionFinder.ArtifactAndVersionModel artifactAndVersion = artifactAndVersionOpt.get();
        String actualGroupId = Objects.requireNonNullElse(pluginGroupId, KILLBILL_GROUP_ID);
        Path result = this.downloadFromPluginInstallUrl(pluginKey, actualGroupId, actualArtifactId = artifactAndVersion.getArtifactId(), actualPluginVersion = artifactAndVersion.getVersion());
        if (result != null && Files.exists(result, new LinkOption[0])) {
            logger.debug("Plugin found in pluginInstall.coordinate.url. Downloaded path: {}", (Object)result);
            return new DownloadResult(result, actualGroupId, actualArtifactId, actualPluginVersion);
        }
        result = this.downloadFromPublicKillbill(pluginKey, actualGroupId, actualArtifactId, actualPluginVersion);
        if (result != null && Files.exists(result, new LinkOption[0])) {
            logger.debug("Plugin not found in pluginInstall.coordinate.url, BUT found in killbill public repository. Downloaded Path: {}", (Object)result);
            return new DownloadResult(result, actualGroupId, actualArtifactId, actualPluginVersion);
        }
        String msg = String.format("Cannot find plugin with key: %s, kbVersion: %s, groupId: %s, artifactId: %s, version: %s. Note that at this point, groupId/artifactId/version might different with input due to search operation by artifactAndVersionFinder.findArtifactAndVersion()", pluginKey, killbillVersion, actualGroupId, actualArtifactId, actualPluginVersion);
        throw new KPMPluginException(msg);
    }

    private Path doDownloadValidateAndVerify(String pluginKey, String version, String pluginJarUrl, String sha1Url) {
        try {
            String fileName = PluginNamingResolver.of(pluginKey, version).getPluginJarFileName();
            Path downloadedFile = Files.createTempDirectory("kpm", new FileAttribute[0]).resolve(fileName);
            this.httpClient.download(pluginJarUrl, this.uriResolver.getHeaders(), downloadedFile);
            if (!Files.exists(downloadedFile, new LinkOption[0]) && Files.size(downloadedFile) <= 0L) {
                throw new KPMPluginException(String.format("Unable to download file named as '%s' from %s", fileName, pluginKey));
            }
            if (!CoordinateBasedPluginDownloader.isValidJarFile(downloadedFile)) {
                throw new KPMPluginException("Plugin downloaded successfully, but it is not a JAR file");
            }
            logger.debug("Downloaded plugin file is a valid JAR file");
            if (!this.sha1Checker.isDownloadedFileVerified(sha1Url, this.uriResolver.getHeaders(), downloadedFile)) {
                throw new KPMPluginException("Plugin downloaded successfully, but SHA1 verification failed");
            }
            logger.debug("Downloaded plugin file is verified");
            return downloadedFile;
        }
        catch (IOException e) {
            throw new KPMPluginException("Problem when creating temporary file for download plugin", e);
        }
        catch (Exception e) {
            logger.error("There's problem when downloading plugin from: {}. Exception: {}", (Object)pluginJarUrl, (Object)e.getMessage());
            return null;
        }
    }

    private Path downloadFromPluginInstallUrl(String pluginKey, String groupId, String artifactId, String version) {
        String jarUrl = this.uriResolver.getBaseUri() + "/" + CoordinateBasedPluginDownloader.coordinateToUri(groupId, artifactId, version, ".jar");
        String sha1Url = this.uriResolver.getBaseUri() + "/" + CoordinateBasedPluginDownloader.coordinateToUri(groupId, artifactId, version, ".jar.sha1");
        logger.debug("#downloadFromPluginInstallUrl() . jarUrl: {}, sha1Url: {}", (Object)jarUrl, (Object)sha1Url);
        return this.doDownloadValidateAndVerify(pluginKey, version, jarUrl, sha1Url);
    }

    private Path downloadFromPublicKillbill(String pluginKey, String groupId, String artifactId, String version) {
        if (this.uriResolver.getBaseUri().startsWith("https://oss.sonatype.org") || this.uriResolver.getBaseUri().startsWith("https://repo1.maven.org/maven2") || !this.shouldTryPublicRepository) {
            return null;
        }
        String jarUrl = SONATYPE_RELEASE_URL + CoordinateBasedPluginDownloader.coordinateToUri(groupId, artifactId, version, ".jar");
        String sha1Url = SONATYPE_RELEASE_URL + CoordinateBasedPluginDownloader.coordinateToUri(groupId, artifactId, version, ".jar.sha1");
        logger.debug("#downloadFromPublicKillbill() . jarUrl: {}, sha1Url: {}", (Object)jarUrl, (Object)sha1Url);
        return this.doDownloadValidateAndVerify(pluginKey, version, jarUrl, sha1Url);
    }

    static String coordinateToUri(String groupId, String artifactId, String pluginVersion, String extension) {
        return groupId.replaceAll("\\.", "/") + "/" + artifactId + "/" + pluginVersion + "/" + artifactId + "-" + pluginVersion + extension;
    }

    static boolean isValidJarFile(Path path) {
        boolean bl;
        JarFile jarFile = new JarFile(path.toFile());
        try {
            logger.debug("Actual version from downloaded plugin JAR file: {}", (Object)jarFile.getVersion());
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.debug("Downloaded plugin: {} is not a JAR file", (Object)path);
                return false;
            }
        }
        jarFile.close();
        return bl;
    }

    static class DownloadResult {
        private final Path downloadedPath;
        private final String groupId;
        private final String artifactId;
        private final String pluginVersion;

        DownloadResult(Path downloadedPath, String groupId, String artifactId, String pluginVersion) {
            this.downloadedPath = downloadedPath;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.pluginVersion = pluginVersion;
        }

        public Path getDownloadedPath() {
            return this.downloadedPath;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getPluginVersion() {
            return this.pluginVersion;
        }

        public String toString() {
            return "DownloadResult{downloadedPath=" + this.downloadedPath + ", artifactId='" + this.artifactId + "', pluginVersion='" + this.pluginVersion + "'}";
        }
    }
}

