/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.killbill.billing.osgi.bundles.kpm.UriResolver;

public class BasicUriResolver
implements UriResolver {
    private final String baseUri;
    private final String username;
    private final String password;

    public BasicUriResolver(String baseUri, String username, String password) {
        this.baseUri = baseUri;
        this.username = username;
        this.password = password;
    }

    @Override
    public String getBaseUri() {
        return this.baseUri;
    }

    @Override
    public UriResolver.AuthenticationMethod getAuthMethod() {
        return UriResolver.AuthenticationMethod.BASIC;
    }

    @Override
    public Map<String, String> getHeaders() {
        String credentials = this.username + ":" + this.password;
        String encoded = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
        return Map.of("Authorization", "Basic " + encoded);
    }
}

