/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.killbill.billing.osgi.api.OSGIKillbill;
import org.killbill.billing.osgi.bundles.kpm.KPMClient;
import org.killbill.billing.osgi.bundles.kpm.KPMPluginException;
import org.killbill.billing.osgi.bundles.kpm.KpmProperties;
import org.killbill.billing.osgi.bundles.kpm.PluginsDirectoryDAO;
import org.killbill.billing.osgi.bundles.kpm.UriResolver;
import org.killbill.billing.osgi.bundles.kpm.VersionsProvider;
import org.killbill.billing.osgi.bundles.kpm.impl.DefaultNexusMetadataFiles;
import org.killbill.billing.osgi.bundles.kpm.impl.DefaultPluginsDirectoryDAO;
import org.killbill.billing.osgi.bundles.kpm.impl.DefaultVersionsProvider;
import org.killbill.billing.osgi.bundles.kpm.impl.FilesUtils;
import org.killbill.billing.osgi.bundles.kpm.impl.PluginNamingResolver;
import org.killbill.billing.osgi.bundles.kpm.impl.UrlResolverFactory;
import org.killbill.billing.util.nodes.NodeInfo;
import org.killbill.commons.utils.Preconditions;
import org.killbill.commons.utils.Strings;
import org.killbill.commons.utils.cache.Cache;
import org.killbill.commons.utils.cache.DefaultCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvailablePluginsComponentsFactory {
    private final Logger logger = LoggerFactory.getLogger(AvailablePluginsComponentsFactory.class);
    private final OSGIKillbill osgiKillbill;
    private final KPMClient httpClient;
    private final KpmProperties kpmProperties;
    private final UrlResolverFactory urlResolverFactory;
    private final boolean isCacheEnabled;
    private final Cache<CacheKey, VersionsProvider> versionsProviderCache;
    private final Cache<CacheKey, Set<PluginsDirectoryDAO.PluginsDirectoryModel>> pluginDirectoryCache;

    public AvailablePluginsComponentsFactory(OSGIKillbill osgiKillbill, KPMClient httpClient, KpmProperties kpmProperties) {
        this.osgiKillbill = osgiKillbill;
        this.httpClient = httpClient;
        this.kpmProperties = kpmProperties;
        this.urlResolverFactory = new UrlResolverFactory(kpmProperties);
        this.isCacheEnabled = kpmProperties.availablePlugins().cache().isEnabled();
        int cacheSize = kpmProperties.availablePlugins().cache().getSize();
        int expirationSec = kpmProperties.availablePlugins().cache().getExpirationSec();
        if (this.isCacheEnabled) {
            this.versionsProviderCache = new DefaultCache(cacheSize, expirationSec, DefaultCache.noCacheLoader());
            this.pluginDirectoryCache = new DefaultCache(cacheSize, expirationSec, DefaultCache.noCacheLoader());
        } else {
            this.versionsProviderCache = null;
            this.pluginDirectoryCache = null;
        }
    }

    Function<CacheKey, VersionsProvider> getVersionsProviderLoader(UriResolver uriResolver) {
        return key -> {
            DefaultVersionsProvider defaultVersionsProvider;
            Path ossParentPomXml;
            Path killbillPomXml;
            DefaultNexusMetadataFiles mavenMetadataFiles;
            block5: {
                String mavenMetadataUrl = this.kpmProperties.getNexusMavenMetadataUrl();
                mavenMetadataFiles = new DefaultNexusMetadataFiles(this.httpClient, uriResolver, mavenMetadataUrl, key.getVersion());
                NodeInfo nodeInfo = this.osgiKillbill.getKillbillNodesApi().getCurrentNodeInfo();
                killbillPomXml = null;
                ossParentPomXml = null;
                killbillPomXml = mavenMetadataFiles.getKillbillPomXml();
                if (!nodeInfo.getKillbillVersion().equals(key.getVersion())) break block5;
                DefaultVersionsProvider defaultVersionsProvider2 = new DefaultVersionsProvider(killbillPomXml, nodeInfo);
                FilesUtils.deleteIfExists(killbillPomXml);
                FilesUtils.deleteIfExists(ossParentPomXml);
                mavenMetadataFiles.cleanup();
                return defaultVersionsProvider2;
            }
            try {
                ossParentPomXml = mavenMetadataFiles.getOssParentPomXml();
                defaultVersionsProvider = new DefaultVersionsProvider(killbillPomXml, ossParentPomXml);
            }
            catch (Exception e) {
                try {
                    throw new KPMPluginException(String.format("Unable to get killbill version info: %s", key.getVersion()), e);
                }
                catch (Throwable throwable) {
                    FilesUtils.deleteIfExists(killbillPomXml);
                    FilesUtils.deleteIfExists(ossParentPomXml);
                    mavenMetadataFiles.cleanup();
                    throw throwable;
                }
            }
            FilesUtils.deleteIfExists(killbillPomXml);
            FilesUtils.deleteIfExists(ossParentPomXml);
            mavenMetadataFiles.cleanup();
            return defaultVersionsProvider;
        };
    }

    Function<CacheKey, Set<PluginsDirectoryDAO.PluginsDirectoryModel>> getPluginsDirectoryLoader(UriResolver uriResolver) {
        return key -> {
            DefaultPluginsDirectoryDAO pluginsDirectoryDAO = new DefaultPluginsDirectoryDAO(this.httpClient, uriResolver, key.getVersion());
            return pluginsDirectoryDAO.getPlugins();
        };
    }

    public VersionsProvider createVersionsProvider(String killbillVersionOrLatest, boolean forceDownload) throws KPMPluginException {
        this.logger.debug("#createVersionsProvider() with version:{}, forceDownload:{}, cacheEnabled: {}", new Object[]{killbillVersionOrLatest, forceDownload, this.isCacheEnabled});
        UriResolver uriResolver = this.urlResolverFactory.getVersionsProviderUrlResolver();
        CacheKey cacheKey = CacheKey.of(killbillVersionOrLatest, uriResolver.getBaseUri());
        if (!this.isCacheEnabled) {
            return this.getVersionsProviderLoader(uriResolver).apply(cacheKey);
        }
        VersionsProvider result = this.versionsProviderCache.getOrLoad(cacheKey, forceDownload ? this.getVersionsProviderLoader(uriResolver) : key -> VersionsProvider.ZERO);
        this.versionsProviderCache.put(cacheKey, result);
        return result;
    }

    public PluginsDirectoryDAO createPluginsDirectoryDAO(String fixedKillbillVersion, boolean forceDownload) throws KPMPluginException {
        this.logger.debug("#createPluginsDirectoryDAO() with killbillVersion: {}, forceDownload: {}, cacheEnabled: {}", new Object[]{fixedKillbillVersion, forceDownload, this.isCacheEnabled});
        String version = PluginNamingResolver.getVersionFromString(fixedKillbillVersion);
        if (Strings.isNullOrEmpty(version)) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid killbill version in createPluginsDirectoryDAO()", fixedKillbillVersion));
        }
        CacheKey cacheKey = CacheKey.of(version, this.kpmProperties.pluginsDirectory().getUrl());
        UriResolver uriResolver = this.urlResolverFactory.getPluginDirectoryUrlResolver();
        if (!this.isCacheEnabled) {
            return () -> this.getPluginsDirectoryLoader(uriResolver).apply(cacheKey);
        }
        PluginsDirectoryDAO result = () -> this.pluginDirectoryCache.getOrLoad(cacheKey, forceDownload ? this.getPluginsDirectoryLoader(uriResolver) : key -> Collections.emptySet());
        this.pluginDirectoryCache.put(cacheKey, result.getPlugins());
        return result;
    }

    static class CacheKey {
        private final String version;
        private final String url;

        CacheKey(String version, String url) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(version), "version in CacheKey is null or empty", new Object[0]);
            Preconditions.checkArgument(!Strings.isNullOrEmpty(url), "url in CacheKey is null or empty", new Object[0]);
            this.version = version;
            this.url = url;
        }

        static CacheKey of(String version, String url) {
            return new CacheKey(version, url);
        }

        public String getVersion() {
            return this.version;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.version.equals(cacheKey.version) && this.url.equals(cacheKey.url);
        }

        public int hashCode() {
            return Objects.hash(this.version, this.url);
        }
    }
}

