/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm.impl;

import java.util.Optional;
import org.killbill.billing.osgi.bundles.kpm.PluginIdentifiersDAO;
import org.killbill.billing.osgi.bundles.kpm.PluginsDirectoryDAO;
import org.killbill.billing.osgi.bundles.kpm.impl.AvailablePluginsComponentsFactory;
import org.killbill.billing.osgi.bundles.kpm.impl.PluginNamingResolver;
import org.killbill.commons.utils.Strings;
import org.killbill.commons.utils.annotation.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArtifactAndVersionFinder {
    private final Logger logger = LoggerFactory.getLogger(ArtifactAndVersionFinder.class);
    private final PluginIdentifiersDAO pluginIdentifiersDAO;
    private final AvailablePluginsComponentsFactory availablePluginsComponentsFactory;

    ArtifactAndVersionFinder(PluginIdentifiersDAO pluginIdentifiersDAO, AvailablePluginsComponentsFactory factory) {
        this.pluginIdentifiersDAO = pluginIdentifiersDAO;
        this.availablePluginsComponentsFactory = factory;
    }

    Optional<ArtifactAndVersionModel> findArtifactAndVersion(String killbillVersion, String pluginKey, String pluginArtifactId, String pluginVersion, boolean forceDownload) {
        this.logger.info("#findArtifactAndVersion() kbVersion: {}, pluginKey: {}, artifactId: {}, pluginVersion: {}, forceDownload: {}", new Object[]{killbillVersion, pluginKey, pluginArtifactId, pluginVersion, forceDownload});
        if (!Strings.isNullOrEmpty(pluginArtifactId) && !Strings.isNullOrEmpty(pluginVersion)) {
            return Optional.of(new ArtifactAndVersionModel(pluginArtifactId, pluginVersion));
        }
        ArtifactAndVersionModel result = this.searchFromPluginsIdentifier(pluginKey, forceDownload);
        if (result.isAttributesSet()) {
            return Optional.of(result);
        }
        result = this.searchFromPluginsDirectory(killbillVersion, pluginKey, forceDownload);
        if (result.isAttributesSet()) {
            return Optional.of(result);
        }
        if (!Strings.isNullOrEmpty(result.getVersion()) && Strings.isNullOrEmpty(result.getArtifactId())) {
            String pluginNameAsArtifactId = PluginNamingResolver.of(pluginKey).getPluginName();
            result.setArtifactIdIfNull(pluginNameAsArtifactId);
            this.logger.debug("#findArtifactAndVersion() will set artifactId='{}' using PluginNamingResolver", (Object)pluginNameAsArtifactId);
            return Optional.of(result);
        }
        this.logger.info("#findArtifactAndVersion() will return empty object. Cannot find plugin key: '{}' in PluginIdentifiers and PluginsDirectory", (Object)pluginKey);
        return Optional.empty();
    }

    @VisibleForTesting
    ArtifactAndVersionModel searchFromPluginsIdentifier(String pluginKey, boolean forceDownload) {
        ArtifactAndVersionModel result = new ArtifactAndVersionModel();
        if (forceDownload) {
            this.logger.debug("#searchFromPluginsIdentifier() forceDownload=true. Search will be skipped and use #searchFromPluginsDirectory() instead");
            return result;
        }
        PluginIdentifiersDAO.PluginIdentifiersModel model = this.pluginIdentifiersDAO.getPluginIdentifiers().stream().filter(m4 -> pluginKey.equals(m4.getPluginKey()) && m4.getPluginIdentifier() != null).findFirst().orElse(null);
        if (model == null || model.getPluginIdentifier() == null) {
            this.logger.debug("#searchFromPluginsIdentifier() with pluginKey: '{}' does not have any result", (Object)pluginKey);
            return result;
        }
        this.logger.debug("#searchFromPluginsIdentifier() with pluginKey: '{}' found pluginIdentifier's artifact/version: {}", (Object)pluginKey, (Object)model);
        result.setArtifactIdIfNull(model.getPluginIdentifier().getArtifactId());
        result.setVersionIfNull(model.getPluginIdentifier().getVersion());
        if (result.isAttributesSet()) {
            this.logger.debug("#searchFromPluginsIdentifier() found all artifact and version attributes: {}", (Object)result);
        } else {
            this.logger.debug("#searchFromPluginsIdentifier() still have null/empty model attributes: {}", (Object)result);
        }
        return result;
    }

    @VisibleForTesting
    ArtifactAndVersionModel searchFromPluginsDirectory(String killbillVersion, String pluginKey, boolean forceDownload) {
        this.logger.debug("#searchFromPluginsDirectory() using PluginsDirectoryDAO#createPluginsDirectoryDAO() using pluginKey: {}", (Object)pluginKey);
        ArtifactAndVersionModel result = new ArtifactAndVersionModel();
        PluginsDirectoryDAO.PluginsDirectoryModel model = this.availablePluginsComponentsFactory.createPluginsDirectoryDAO(killbillVersion, forceDownload).getPlugins().stream().filter(m4 -> m4.getPluginKey().equals(pluginKey)).findFirst().orElse(null);
        if (model != null) {
            this.logger.debug("#searchFromPluginsDirectory() found artifact/version from PluginsDirectoryDAO: {}", (Object)model);
            result.setArtifactIdIfNull(model.getPluginArtifactId());
            result.setVersionIfNull(model.getPluginVersion());
        }
        if (result.isAttributesSet()) {
            this.logger.debug("#searchFromPluginsDirectory() all ArtifactAndVersionModel attributes set : {}", (Object)result);
        } else {
            this.logger.debug("#searchFromPluginsDirectory() one or more ArtifactAndVersionModel attribute(s) still contains null/empty: {}", (Object)result);
        }
        return result;
    }

    static class ArtifactAndVersionModel {
        private String artifactId;
        private String version;

        ArtifactAndVersionModel() {
        }

        public ArtifactAndVersionModel(String artifactId, String version) {
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactIdIfNull(String artifactId) {
            this.artifactId = Strings.isNullOrEmpty(this.artifactId) ? artifactId : this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersionIfNull(String version) {
            this.version = Strings.isNullOrEmpty(this.version) ? version : this.version;
        }

        public boolean isAttributesSet() {
            return !Strings.isNullOrEmpty(this.artifactId) && !Strings.isNullOrEmpty(this.version);
        }

        public String toString() {
            return "ArtifactAndVersionModel{artifactId='" + this.artifactId + "', version='" + this.version + "'}";
        }
    }
}

