/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public interface PluginsDirectoryDAO {
    public static final String DEFAULT_DIRECTORY = "https://raw.githubusercontent.com/killbill/killbill-cloud/master/kpm/lib/kpm/plugins_directory.yml";
    public static final PluginsDirectoryDAO NONE = Collections::emptySet;

    public Set<PluginsDirectoryModel> getPlugins();

    public static class PluginsDirectoryModel
    implements Comparable<PluginsDirectoryModel> {
        private final String pluginKey;
        private final String pluginVersion;
        private String pluginArtifactId;

        public PluginsDirectoryModel(String pluginKey, String pluginVersion) {
            this.pluginKey = pluginKey;
            this.pluginVersion = pluginVersion;
        }

        public String getPluginKey() {
            return this.pluginKey;
        }

        public String getPluginVersion() {
            return this.pluginVersion;
        }

        public String getPluginArtifactId() {
            return this.pluginArtifactId;
        }

        public void setPluginArtifactId(String pluginArtifactId) {
            this.pluginArtifactId = pluginArtifactId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginsDirectoryModel that = (PluginsDirectoryModel)o;
            return this.pluginKey.equals(that.pluginKey) && this.pluginVersion.equals(that.pluginVersion);
        }

        public int hashCode() {
            return Objects.hash(this.pluginKey, this.pluginVersion);
        }

        @Override
        public int compareTo(PluginsDirectoryModel o) {
            return this.pluginKey.compareTo(o.getPluginKey());
        }

        public String toString() {
            return "AvailablePluginsModel{pluginKey='" + this.pluginKey + "', pluginVersion='" + this.pluginVersion + "', pluginArtifactId='" + this.pluginArtifactId + "'}";
        }
    }
}

