/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.killbill.billing.osgi.bundles.kpm.KPMPluginException;
import org.killbill.billing.osgi.bundles.kpm.PluginsDirectoryDAO;
import org.killbill.commons.utils.annotation.VisibleForTesting;

public interface PluginManager {
    public GetAvailablePluginsModel getAvailablePlugins(@Nonnull String var1, boolean var2) throws KPMPluginException;

    public void install(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3) throws KPMPluginException;

    public void install(@Nonnull String var1, @Nonnull String var2, String var3, String var4, String var5, boolean var6) throws KPMPluginException;

    public void uninstall(String var1, String var2) throws KPMPluginException;

    public static class AvailablePluginsSerializer
    extends StdSerializer<SortedSet<PluginsDirectoryDAO.PluginsDirectoryModel>> {
        protected AvailablePluginsSerializer() {
            this((Class<SortedSet<PluginsDirectoryDAO.PluginsDirectoryModel>>)null);
        }

        protected AvailablePluginsSerializer(Class<SortedSet<PluginsDirectoryDAO.PluginsDirectoryModel>> t2) {
            super(t2);
        }

        @Override
        public void serialize(SortedSet<PluginsDirectoryDAO.PluginsDirectoryModel> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            for (PluginsDirectoryDAO.PluginsDirectoryModel model : value) {
                gen.writeStringField(model.getPluginKey(), model.getPluginVersion());
            }
            gen.writeEndObject();
        }
    }

    public static class KillbillArtifactsVersion {
        @JsonProperty(value="killbill")
        private String killbill = "";
        @JsonProperty(value="killbill-oss-parent")
        private String ossParent = "";
        @JsonProperty(value="killbill-api")
        private String api = "";
        @JsonProperty(value="killbill-plugin-api")
        private String pluginApi = "";
        @JsonProperty(value="killbill-commons")
        private String commons = "";
        @JsonProperty(value="killbill-platform")
        private String platform = "";

        public KillbillArtifactsVersion() {
        }

        KillbillArtifactsVersion(KillbillArtifactsVersion other) {
            this.killbill = other.getKillbill();
            this.ossParent = other.getOssParent();
            this.api = other.getApi();
            this.pluginApi = other.getPluginApi();
            this.commons = other.getCommons();
            this.platform = other.getPlatform();
        }

        public String getKillbill() {
            return this.killbill;
        }

        public void setKillbill(String killbill) {
            this.killbill = killbill;
        }

        public String getOssParent() {
            return this.ossParent;
        }

        public void setOssParent(String ossParent) {
            this.ossParent = ossParent;
        }

        public String getApi() {
            return this.api;
        }

        public void setApi(String api) {
            this.api = api;
        }

        public String getPluginApi() {
            return this.pluginApi;
        }

        public void setPluginApi(String pluginApi) {
            this.pluginApi = pluginApi;
        }

        public String getCommons() {
            return this.commons;
        }

        public void setCommons(String commons) {
            this.commons = commons;
        }

        public String getPlatform() {
            return this.platform;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }
    }

    public static final class GetAvailablePluginsModel {
        @JsonProperty(value="killbill")
        private final KillbillArtifactsVersion killbillArtifactsVersion = new KillbillArtifactsVersion();
        @JsonProperty(value="plugins")
        @JsonSerialize(using=AvailablePluginsSerializer.class)
        private final SortedSet<PluginsDirectoryDAO.PluginsDirectoryModel> availablePlugins = new TreeSet<PluginsDirectoryDAO.PluginsDirectoryModel>();

        public void addKillbillVersion(String fixedKillbillVersion) {
            this.killbillArtifactsVersion.setKillbill(fixedKillbillVersion);
        }

        public void addOssParentVersion(String ossParentVersion) {
            this.killbillArtifactsVersion.setOssParent(ossParentVersion);
        }

        public void addApiVersion(String killbillApiVersion) {
            this.killbillArtifactsVersion.setApi(killbillApiVersion);
        }

        public void addPluginApiVersion(String killbillPluginApiVersion) {
            this.killbillArtifactsVersion.setPluginApi(killbillPluginApiVersion);
        }

        public void addCommonsVersion(String killbillCommonsVersion) {
            this.killbillArtifactsVersion.setCommons(killbillCommonsVersion);
        }

        public void addPlatformVersion(String killbillPlatformVersion) {
            this.killbillArtifactsVersion.setPlatform(killbillPlatformVersion);
        }

        public void addPlugins(String pluginKey, String version) {
            this.availablePlugins.add(new PluginsDirectoryDAO.PluginsDirectoryModel(pluginKey, version));
        }

        public KillbillArtifactsVersion getKillbillArtifactsVersion() {
            return new KillbillArtifactsVersion(this.killbillArtifactsVersion);
        }

        @VisibleForTesting
        public SortedSet<PluginsDirectoryDAO.PluginsDirectoryModel> getAvailablePlugins() {
            return new TreeSet<PluginsDirectoryDAO.PluginsDirectoryModel>(this.availablePlugins);
        }
    }
}

