/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.killbill.commons.utils.annotation.VisibleForTesting;

public interface PluginIdentifiersDAO {
    public void add(@Nonnull String var1, @Nonnull String var2);

    public void add(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3, @Nonnull String var4);

    public void remove(@Nonnull String var1);

    public Set<PluginIdentifiersModel> getPluginIdentifiers();

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static final class PluginIdentifierModel {
        private final String pluginName;
        private final String groupId;
        private final String artifactId;
        private final String packaging = "jar";
        private final String classifier;
        private final String version;
        private final String language = "java";

        private PluginIdentifierModel(String pluginName, String groupId, String artifactId, String classifier, String version) {
            this.pluginName = pluginName;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.classifier = classifier;
            this.version = version;
        }

        public PluginIdentifierModel(String pluginName, String version) {
            this(pluginName, null, null, null, version);
        }

        public PluginIdentifierModel(String pluginName, String groupId, String artifactId, String version) {
            this(pluginName, groupId, artifactId, null, version);
        }

        @VisibleForTesting
        PluginIdentifierModel() {
            this(null, null, null, null, null);
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getPackaging() {
            return "jar";
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getVersion() {
            return this.version;
        }

        public String getLanguage() {
            return "java";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginIdentifierModel that = (PluginIdentifierModel)o;
            return this.pluginName.equals(that.pluginName) && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.classifier, that.classifier) && this.version.equals(that.version);
        }

        public int hashCode() {
            return Objects.hash(this.pluginName, this.groupId, this.artifactId, this.classifier, this.version);
        }

        public String toString() {
            return "PluginIdentifierModel{pluginName='" + this.pluginName + "', groupId='" + this.groupId + "', artifactId='" + this.artifactId + "', packaging='jar', classifier='" + this.classifier + "', version='" + this.version + "', language='java'}";
        }
    }

    public static final class PluginIdentifiersModel {
        private final String pluginKey;
        private final PluginIdentifierModel pluginIdentifier;

        public PluginIdentifiersModel(String pluginKey, PluginIdentifierModel pluginIdentifier) {
            this.pluginKey = pluginKey;
            this.pluginIdentifier = pluginIdentifier;
        }

        public String getPluginKey() {
            return this.pluginKey;
        }

        public PluginIdentifierModel getPluginIdentifier() {
            return this.pluginIdentifier;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginIdentifiersModel that = (PluginIdentifiersModel)o;
            return this.pluginKey.equals(that.pluginKey);
        }

        public int hashCode() {
            return Objects.hash(this.pluginKey);
        }

        public String toString() {
            return "PluginIdentifiersModel{pluginKey='" + this.pluginKey + "', pluginIdentifier=" + this.pluginIdentifier + "}";
        }
    }
}

