/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm;

import org.killbill.billing.osgi.bundles.kpm.KPMPluginException;
import org.killbill.billing.osgi.bundles.kpm.KpmProperties;
import org.killbill.commons.utils.annotation.VisibleForTesting;

public final class KpmPropertiesValidator {
    private final KpmProperties kpmProperties;

    public KpmPropertiesValidator(KpmProperties kpmProperties) {
        this.kpmProperties = kpmProperties;
    }

    public void validate() throws KPMPluginException {
        this.validateNexusUrl();
        this.validateNexusRepository();
    }

    @VisibleForTesting
    void validateNexusUrl() throws KPMPluginException {
        if (this.kpmProperties.getNexusUrl().endsWith("/")) {
            throw new KPMPluginException("nexusUrl should not end with a trailing slash");
        }
    }

    @VisibleForTesting
    void validateNexusRepository() throws KPMPluginException {
        String toValidate = this.kpmProperties.getNexusRepository();
        if (!toValidate.startsWith("/") || toValidate.endsWith("/")) {
            throw new KPMPluginException("nexusRepository should start with a slash and not end with a trailing slash");
        }
    }
}

