/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm;

import java.nio.file.Path;
import java.util.Objects;
import java.util.Properties;
import org.killbill.commons.utils.Strings;

public final class KpmProperties {
    private static final String PROPERTY_PREFIX = "org.killbill.billing.plugin.kpm.";
    private static final String AVAILABLE_PLUGINS_PREFIX = "org.killbill.billing.plugin.kpm.availablePlugins.";
    private static final String PLUGINS_DIRECTORY_PREFIX = "org.killbill.billing.plugin.kpm.pluginsDirectory.";
    private static final String PLUGIN_INSTALL_PREFIX = "org.killbill.billing.plugin.kpm.pluginInstall.";
    private final Properties properties = new Properties();

    public KpmProperties(Properties killbillProperties) {
        killbillProperties.stringPropertyNames().forEach(key -> this.properties.setProperty((String)key, killbillProperties.getProperty((String)key)));
    }

    public Path getBundlesPath() {
        String bundleInstallDir = this.properties.getProperty("org.killbill.osgi.bundle.install.dir");
        return Strings.isNullOrEmpty(bundleInstallDir) ? Path.of("/var", "tmp", "bundles") : Path.of(bundleInstallDir, new String[0]);
    }

    public String getKillbillAdminUsername() {
        return Objects.requireNonNullElse(this.properties.getProperty("org.killbill.billing.plugin.kpm.adminUsername"), "admin");
    }

    public String getKillbillAdminPassword() {
        return Objects.requireNonNullElse(this.properties.getProperty("org.killbill.billing.plugin.kpm.adminPassword"), "password");
    }

    public String getNexusUrl() {
        return Objects.requireNonNullElse(this.properties.getProperty("org.killbill.billing.plugin.kpm.nexusUrl"), "https://oss.sonatype.org");
    }

    public String getNexusRepository() {
        return Objects.requireNonNullElse(this.properties.getProperty("org.killbill.billing.plugin.kpm.nexusRepository"), "/releases");
    }

    public String getNexusMavenMetadataUrl() {
        return Objects.requireNonNullElse(this.properties.getProperty("org.killbill.billing.plugin.kpm.nexusMavenMetadataUrl"), "https://repo1.maven.org/maven2/org/kill-bill/billing/killbill/maven-metadata.xml");
    }

    public String getNexusAuthMethod() {
        return Objects.requireNonNullElse(this.properties.getProperty("org.killbill.billing.plugin.kpm.nexusAuthMethod"), "NONE");
    }

    public String getNexusAuthUsername() {
        return Objects.requireNonNullElse(this.properties.getProperty("org.killbill.billing.plugin.kpm.nexusAuthUsername"), "username");
    }

    public String getNexusAuthPassword() {
        return Objects.requireNonNullElse(this.properties.getProperty("org.killbill.billing.plugin.kpm.nexusAuthPassword"), "password");
    }

    public String getNexusAuthToken() {
        return Objects.requireNonNullElse(this.properties.getProperty("org.killbill.billing.plugin.kpm.nexusAuthToken"), "VALID_TOKEN");
    }

    public boolean isStrictSSL() {
        return Boolean.parseBoolean(this.properties.getProperty("org.killbill.billing.plugin.kpm.strictSSL"));
    }

    public int getReadTimeoutSec() {
        return Integer.parseInt(Objects.requireNonNullElse(this.properties.getProperty("org.killbill.billing.plugin.kpm.readTimeoutSec"), "60"));
    }

    public int getConnectTimeoutSec() {
        return Integer.parseInt(Objects.requireNonNullElse(this.properties.getProperty("org.killbill.billing.plugin.kpm.connectTimeoutSec"), "60"));
    }

    public AvailablePlugins availablePlugins() {
        return new AvailablePlugins();
    }

    public PluginsDirectory pluginsDirectory() {
        return new PluginsDirectory();
    }

    public PluginsInstall pluginsInstall() {
        return new PluginsInstall();
    }

    public final class PluginsInstall {
        public Coordinate coordinate() {
            return new Coordinate();
        }

        public final class Coordinate {
            public boolean isVerifySHA1() {
                return Boolean.parseBoolean(KpmProperties.this.properties.getProperty("org.killbill.billing.plugin.kpm.pluginInstall.coordinate.isVerifySHA1"));
            }

            public String getUrl() {
                return (String)((Object)Objects.requireNonNullElse(KpmProperties.this.properties.getProperty("org.killbill.billing.plugin.kpm.pluginInstall.coordinate.url"), KpmProperties.this.getNexusUrl() + "/" + KpmProperties.this.getNexusRepository()));
            }

            public String getAuthMethod() {
                return Objects.requireNonNullElse(KpmProperties.this.properties.getProperty("org.killbill.billing.plugin.kpm.pluginInstall.coordinate.authMethod"), KpmProperties.this.getNexusAuthMethod());
            }

            public String getAuthUsername() {
                return Objects.requireNonNullElse(KpmProperties.this.properties.getProperty("org.killbill.billing.plugin.kpm.pluginInstall.coordinate.authUsername"), KpmProperties.this.getNexusAuthUsername());
            }

            public String getAuthPassword() {
                return Objects.requireNonNullElse(KpmProperties.this.properties.getProperty("org.killbill.billing.plugin.kpm.pluginInstall.coordinate.authPassword"), KpmProperties.this.getNexusAuthPassword());
            }

            public String getAuthToken() {
                return Objects.requireNonNullElse(KpmProperties.this.properties.getProperty("org.killbill.billing.plugin.kpm.pluginInstall.coordinate.authToken"), KpmProperties.this.getNexusAuthToken());
            }

            public boolean isAlwaysTryPublicRepository() {
                return Boolean.parseBoolean(KpmProperties.this.properties.getProperty("org.killbill.billing.plugin.kpm.pluginInstall.coordinate.alwaysTryPublicRepository"));
            }
        }
    }

    public final class PluginsDirectory {
        public String getUrl() {
            return Objects.requireNonNullElse(KpmProperties.this.properties.getProperty("org.killbill.billing.plugin.kpm.pluginsDirectory.url"), "https://raw.githubusercontent.com/killbill/killbill-cloud/master/kpm/lib/kpm/plugins_directory.yml");
        }

        public String getAuthMethod() {
            return Objects.requireNonNullElse(KpmProperties.this.properties.getProperty("org.killbill.billing.plugin.kpm.pluginsDirectory.authMethod"), "NONE");
        }

        public String getAuthUsername() {
            return Objects.requireNonNullElse(KpmProperties.this.properties.getProperty("org.killbill.billing.plugin.kpm.pluginsDirectory.authUsername"), "<none>");
        }

        public String getAuthPassword() {
            return Objects.requireNonNullElse(KpmProperties.this.properties.getProperty("org.killbill.billing.plugin.kpm.pluginsDirectory.authPassword"), "<none>");
        }

        public String getAuthToken() {
            return Objects.requireNonNullElse(KpmProperties.this.properties.getProperty("org.killbill.billing.plugin.kpm.pluginsDirectory.authToken"), "<none>");
        }
    }

    public final class AvailablePlugins {
        public Cache cache() {
            return new Cache();
        }

        public final class Cache {
            public int getSize() {
                return Integer.parseInt(Objects.requireNonNullElse(KpmProperties.this.properties.getProperty("org.killbill.billing.plugin.kpm.availablePlugins.cache.size"), "10"));
            }

            public int getExpirationSec() {
                return Integer.parseInt(Objects.requireNonNullElse(KpmProperties.this.properties.getProperty("org.killbill.billing.plugin.kpm.availablePlugins.cache.expirationSecs"), "86460"));
            }

            public boolean isEnabled() {
                return Boolean.parseBoolean(KpmProperties.this.properties.getProperty("org.killbill.billing.plugin.kpm.availablePlugins.cache.enabled"));
            }
        }
    }
}

