/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.bundles.kpm;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.Map;
import org.killbill.billing.plugin.util.http.HttpClient;
import org.killbill.billing.plugin.util.http.InvalidRequest;
import org.killbill.billing.plugin.util.http.ResponseFormat;
import org.killbill.commons.utils.Strings;

public class KPMClient
extends HttpClient {
    public KPMClient(boolean strictSSL, int connectTimeoutMs, int requestTimeoutMs) throws GeneralSecurityException {
        super(null, null, null, null, null, strictSSL, connectTimeoutMs, requestTimeoutMs);
    }

    @Override
    protected HttpRequest.Builder getBuilderWithHeaderAndQuery(String verb, String url, Map<String, String> headers, Map<String, String> queryParams) throws URISyntaxException {
        HttpRequest.Builder builder = super.getBuilderWithHeaderAndQuery(verb, url, headers, queryParams);
        builder.setHeader("User-Agent", "KillBill/kpm-plugin/1.0");
        return builder;
    }

    @Override
    public HttpClient.Builder httpClientBuilder(boolean strictSSL, int connectTimeoutMs, String proxyHost, Integer proxyPort) throws GeneralSecurityException {
        return super.httpClientBuilder(strictSSL, connectTimeoutMs, proxyHost, proxyPort).followRedirects(HttpClient.Redirect.NORMAL);
    }

    public void download(String uri, Path target) throws InvalidRequest, IOException, URISyntaxException, InterruptedException {
        this.download(uri, Collections.emptyMap(), target);
    }

    public void download(String uri, Map<String, String> headers, Path target) throws InvalidRequest, IOException, URISyntaxException, InterruptedException {
        try (InputStream is = this.doCall("GET", uri, null, Collections.emptyMap(), headers, InputStream.class, ResponseFormat.RAW);){
            Files.copy(is, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public Path downloadToTempOS(String url, String ... nameAndExt) {
        return this.downloadToTempOS(url, Collections.emptyMap(), nameAndExt);
    }

    public Path downloadToTempOS(String url, Map<String, String> headers, String ... nameAndExt) {
        Path target = this.createTarget(nameAndExt);
        try (InputStream is = this.doCall("GET", url, null, Collections.emptyMap(), headers, InputStream.class, ResponseFormat.RAW);){
            Files.copy(is, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (InvalidRequest ir) {
            throw new IllegalArgumentException(String.format("GET request to '%s' throw InvalidRequest", url), ir);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error when GET request to '%s', because: %s", url, e.getMessage()), e);
        }
        return target;
    }

    private Path createTarget(String ... names) {
        try {
            if (names == null) {
                String fileName = "kpm";
                String ext = ".tmp";
                return Files.createTempFile("kpm", ".tmp", new FileAttribute[0]);
            }
            if (!Strings.isNullOrEmpty(names[0]) && !Strings.isNullOrEmpty(names[1])) {
                return Files.createTempFile(names[0], names[1], new FileAttribute[0]);
            }
            if (!Strings.isNullOrEmpty(names[0])) {
                return Files.createTempFile(names[0], ".tmp", new FileAttribute[0]);
            }
            return this.createTarget(null);
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot create temp file for downloaded file because: " + ex.getMessage());
        }
    }
}

