/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.plugin.api.boilerplate.plugin;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.joda.time.DateTime;
import org.killbill.billing.invoice.plugin.api.PriorInvoiceResult;
import org.killbill.billing.payment.api.PluginProperty;

@JsonDeserialize(builder=Builder.class)
public class PriorInvoiceResultImp
implements PriorInvoiceResult {
    protected Iterable<PluginProperty> adjustedPluginProperties;
    protected boolean isAborted;
    protected DateTime rescheduleDate;

    public PriorInvoiceResultImp(PriorInvoiceResultImp that) {
        this.adjustedPluginProperties = that.adjustedPluginProperties;
        this.isAborted = that.isAborted;
        this.rescheduleDate = that.rescheduleDate;
    }

    protected PriorInvoiceResultImp(Builder<?> builder) {
        this.adjustedPluginProperties = builder.adjustedPluginProperties;
        this.isAborted = builder.isAborted;
        this.rescheduleDate = builder.rescheduleDate;
    }

    protected PriorInvoiceResultImp() {
    }

    public Iterable<PluginProperty> getAdjustedPluginProperties() {
        return this.adjustedPluginProperties;
    }

    @JsonGetter(value="isAborted")
    public boolean isAborted() {
        return this.isAborted;
    }

    public DateTime getRescheduleDate() {
        return this.rescheduleDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PriorInvoiceResultImp that = (PriorInvoiceResultImp)o;
        if (!Objects.equals(this.adjustedPluginProperties, that.adjustedPluginProperties)) {
            return false;
        }
        if (this.isAborted != that.isAborted) {
            return false;
        }
        return !(this.rescheduleDate != null ? 0 != this.rescheduleDate.compareTo(that.rescheduleDate) : that.rescheduleDate != null);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.adjustedPluginProperties);
        result = 31 * result + Objects.hashCode(this.isAborted);
        result = 31 * result + Objects.hashCode(this.rescheduleDate);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("adjustedPluginProperties=").append(this.adjustedPluginProperties);
        sb.append(", ");
        sb.append("isAborted=").append(this.isAborted);
        sb.append(", ");
        sb.append("rescheduleDate=").append(this.rescheduleDate);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected Iterable<PluginProperty> adjustedPluginProperties;
        protected boolean isAborted;
        protected DateTime rescheduleDate;

        public Builder() {
        }

        public Builder(Builder that) {
            this.adjustedPluginProperties = that.adjustedPluginProperties;
            this.isAborted = that.isAborted;
            this.rescheduleDate = that.rescheduleDate;
        }

        public T withAdjustedPluginProperties(Iterable<PluginProperty> adjustedPluginProperties) {
            this.adjustedPluginProperties = adjustedPluginProperties;
            return (T)this;
        }

        public T withIsAborted(boolean isAborted) {
            this.isAborted = isAborted;
            return (T)this;
        }

        public T withRescheduleDate(DateTime rescheduleDate) {
            this.rescheduleDate = rescheduleDate;
            return (T)this;
        }

        public T source(PriorInvoiceResult that) {
            this.adjustedPluginProperties = that.getAdjustedPluginProperties();
            this.isAborted = that.isAborted();
            this.rescheduleDate = that.getRescheduleDate();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public PriorInvoiceResultImp build() {
            return new PriorInvoiceResultImp(this.validate());
        }
    }
}

