/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.api.InvoicePayment;
import org.killbill.billing.invoice.api.InvoicePaymentStatus;
import org.killbill.billing.invoice.api.InvoicePaymentType;

@JsonDeserialize(builder=Builder.class)
public class InvoicePaymentImp
implements InvoicePayment {
    protected BigDecimal amount;
    protected DateTime createdDate;
    protected Currency currency;
    protected UUID id;
    protected UUID invoiceId;
    protected UUID linkedInvoicePaymentId;
    protected String paymentCookieId;
    protected DateTime paymentDate;
    protected UUID paymentId;
    protected Currency processedCurrency;
    protected InvoicePaymentStatus status;
    protected InvoicePaymentType type;
    protected DateTime updatedDate;

    public InvoicePaymentImp(InvoicePaymentImp that) {
        this.amount = that.amount;
        this.createdDate = that.createdDate;
        this.currency = that.currency;
        this.id = that.id;
        this.invoiceId = that.invoiceId;
        this.linkedInvoicePaymentId = that.linkedInvoicePaymentId;
        this.paymentCookieId = that.paymentCookieId;
        this.paymentDate = that.paymentDate;
        this.paymentId = that.paymentId;
        this.processedCurrency = that.processedCurrency;
        this.status = that.status;
        this.type = that.type;
        this.updatedDate = that.updatedDate;
    }

    protected InvoicePaymentImp(Builder<?> builder) {
        this.amount = builder.amount;
        this.createdDate = builder.createdDate;
        this.currency = builder.currency;
        this.id = builder.id;
        this.invoiceId = builder.invoiceId;
        this.linkedInvoicePaymentId = builder.linkedInvoicePaymentId;
        this.paymentCookieId = builder.paymentCookieId;
        this.paymentDate = builder.paymentDate;
        this.paymentId = builder.paymentId;
        this.processedCurrency = builder.processedCurrency;
        this.status = builder.status;
        this.type = builder.type;
        this.updatedDate = builder.updatedDate;
    }

    protected InvoicePaymentImp() {
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getInvoiceId() {
        return this.invoiceId;
    }

    public UUID getLinkedInvoicePaymentId() {
        return this.linkedInvoicePaymentId;
    }

    public String getPaymentCookieId() {
        return this.paymentCookieId;
    }

    public DateTime getPaymentDate() {
        return this.paymentDate;
    }

    public UUID getPaymentId() {
        return this.paymentId;
    }

    public Currency getProcessedCurrency() {
        return this.processedCurrency;
    }

    public InvoicePaymentStatus getStatus() {
        return this.status;
    }

    public InvoicePaymentType getType() {
        return this.type;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvoicePaymentImp that = (InvoicePaymentImp)o;
        if (!Objects.equals(this.amount, that.amount)) {
            return false;
        }
        if (this.createdDate != null ? 0 != this.createdDate.compareTo(that.createdDate) : that.createdDate != null) {
            return false;
        }
        if (!Objects.equals(this.currency, that.currency)) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.invoiceId, that.invoiceId)) {
            return false;
        }
        if (!Objects.equals(this.linkedInvoicePaymentId, that.linkedInvoicePaymentId)) {
            return false;
        }
        if (!Objects.equals(this.paymentCookieId, that.paymentCookieId)) {
            return false;
        }
        if (this.paymentDate != null ? 0 != this.paymentDate.compareTo(that.paymentDate) : that.paymentDate != null) {
            return false;
        }
        if (!Objects.equals(this.paymentId, that.paymentId)) {
            return false;
        }
        if (!Objects.equals(this.processedCurrency, that.processedCurrency)) {
            return false;
        }
        if (!Objects.equals(this.status, that.status)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return !(this.updatedDate != null ? 0 != this.updatedDate.compareTo(that.updatedDate) : that.updatedDate != null);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.amount);
        result = 31 * result + Objects.hashCode(this.createdDate);
        result = 31 * result + Objects.hashCode(this.currency);
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.invoiceId);
        result = 31 * result + Objects.hashCode(this.linkedInvoicePaymentId);
        result = 31 * result + Objects.hashCode(this.paymentCookieId);
        result = 31 * result + Objects.hashCode(this.paymentDate);
        result = 31 * result + Objects.hashCode(this.paymentId);
        result = 31 * result + Objects.hashCode(this.processedCurrency);
        result = 31 * result + Objects.hashCode(this.status);
        result = 31 * result + Objects.hashCode(this.type);
        result = 31 * result + Objects.hashCode(this.updatedDate);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("amount=").append(this.amount);
        sb.append(", ");
        sb.append("createdDate=").append(this.createdDate);
        sb.append(", ");
        sb.append("currency=").append(this.currency);
        sb.append(", ");
        sb.append("id=").append(this.id);
        sb.append(", ");
        sb.append("invoiceId=").append(this.invoiceId);
        sb.append(", ");
        sb.append("linkedInvoicePaymentId=").append(this.linkedInvoicePaymentId);
        sb.append(", ");
        sb.append("paymentCookieId=");
        if (this.paymentCookieId == null) {
            sb.append(this.paymentCookieId);
        } else {
            sb.append("'").append(this.paymentCookieId).append("'");
        }
        sb.append(", ");
        sb.append("paymentDate=").append(this.paymentDate);
        sb.append(", ");
        sb.append("paymentId=").append(this.paymentId);
        sb.append(", ");
        sb.append("processedCurrency=").append(this.processedCurrency);
        sb.append(", ");
        sb.append("status=").append(this.status);
        sb.append(", ");
        sb.append("type=").append(this.type);
        sb.append(", ");
        sb.append("updatedDate=").append(this.updatedDate);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected BigDecimal amount;
        protected DateTime createdDate;
        protected Currency currency;
        protected UUID id;
        protected UUID invoiceId;
        protected UUID linkedInvoicePaymentId;
        protected String paymentCookieId;
        protected DateTime paymentDate;
        protected UUID paymentId;
        protected Currency processedCurrency;
        protected InvoicePaymentStatus status;
        protected InvoicePaymentType type;
        protected DateTime updatedDate;

        public Builder() {
        }

        public Builder(Builder that) {
            this.amount = that.amount;
            this.createdDate = that.createdDate;
            this.currency = that.currency;
            this.id = that.id;
            this.invoiceId = that.invoiceId;
            this.linkedInvoicePaymentId = that.linkedInvoicePaymentId;
            this.paymentCookieId = that.paymentCookieId;
            this.paymentDate = that.paymentDate;
            this.paymentId = that.paymentId;
            this.processedCurrency = that.processedCurrency;
            this.status = that.status;
            this.type = that.type;
            this.updatedDate = that.updatedDate;
        }

        public T withAmount(BigDecimal amount) {
            this.amount = amount;
            return (T)this;
        }

        public T withCreatedDate(DateTime createdDate) {
            this.createdDate = createdDate;
            return (T)this;
        }

        public T withCurrency(Currency currency) {
            this.currency = currency;
            return (T)this;
        }

        public T withId(UUID id) {
            this.id = id;
            return (T)this;
        }

        public T withInvoiceId(UUID invoiceId) {
            this.invoiceId = invoiceId;
            return (T)this;
        }

        public T withLinkedInvoicePaymentId(UUID linkedInvoicePaymentId) {
            this.linkedInvoicePaymentId = linkedInvoicePaymentId;
            return (T)this;
        }

        public T withPaymentCookieId(String paymentCookieId) {
            this.paymentCookieId = paymentCookieId;
            return (T)this;
        }

        public T withPaymentDate(DateTime paymentDate) {
            this.paymentDate = paymentDate;
            return (T)this;
        }

        public T withPaymentId(UUID paymentId) {
            this.paymentId = paymentId;
            return (T)this;
        }

        public T withProcessedCurrency(Currency processedCurrency) {
            this.processedCurrency = processedCurrency;
            return (T)this;
        }

        public T withStatus(InvoicePaymentStatus status) {
            this.status = status;
            return (T)this;
        }

        public T withType(InvoicePaymentType type) {
            this.type = type;
            return (T)this;
        }

        public T withUpdatedDate(DateTime updatedDate) {
            this.updatedDate = updatedDate;
            return (T)this;
        }

        public T source(InvoicePayment that) {
            this.amount = that.getAmount();
            this.createdDate = that.getCreatedDate();
            this.currency = that.getCurrency();
            this.id = that.getId();
            this.invoiceId = that.getInvoiceId();
            this.linkedInvoicePaymentId = that.getLinkedInvoicePaymentId();
            this.paymentCookieId = that.getPaymentCookieId();
            this.paymentDate = that.getPaymentDate();
            this.paymentId = that.getPaymentId();
            this.processedCurrency = that.getProcessedCurrency();
            this.status = that.getStatus();
            this.type = that.getType();
            this.updatedDate = that.getUpdatedDate();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public InvoicePaymentImp build() {
            return new InvoicePaymentImp(this.validate());
        }
    }
}

