/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.entitlement.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.killbill.billing.entitlement.api.SubscriptionBundleTimeline;
import org.killbill.billing.entitlement.api.SubscriptionEvent;

@JsonDeserialize(builder=Builder.class)
public class SubscriptionBundleTimelineImp
implements SubscriptionBundleTimeline {
    protected UUID accountId;
    protected UUID bundleId;
    protected String externalKey;
    protected List<SubscriptionEvent> subscriptionEvents;

    public SubscriptionBundleTimelineImp(SubscriptionBundleTimelineImp that) {
        this.accountId = that.accountId;
        this.bundleId = that.bundleId;
        this.externalKey = that.externalKey;
        this.subscriptionEvents = that.subscriptionEvents;
    }

    protected SubscriptionBundleTimelineImp(Builder<?> builder) {
        this.accountId = builder.accountId;
        this.bundleId = builder.bundleId;
        this.externalKey = builder.externalKey;
        this.subscriptionEvents = builder.subscriptionEvents;
    }

    protected SubscriptionBundleTimelineImp() {
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public UUID getBundleId() {
        return this.bundleId;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public List<SubscriptionEvent> getSubscriptionEvents() {
        return this.subscriptionEvents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionBundleTimelineImp that = (SubscriptionBundleTimelineImp)o;
        if (!Objects.equals(this.accountId, that.accountId)) {
            return false;
        }
        if (!Objects.equals(this.bundleId, that.bundleId)) {
            return false;
        }
        if (!Objects.equals(this.externalKey, that.externalKey)) {
            return false;
        }
        return Objects.equals(this.subscriptionEvents, that.subscriptionEvents);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.accountId);
        result = 31 * result + Objects.hashCode(this.bundleId);
        result = 31 * result + Objects.hashCode(this.externalKey);
        result = 31 * result + Objects.hashCode(this.subscriptionEvents);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("accountId=").append(this.accountId);
        sb.append(", ");
        sb.append("bundleId=").append(this.bundleId);
        sb.append(", ");
        sb.append("externalKey=");
        if (this.externalKey == null) {
            sb.append(this.externalKey);
        } else {
            sb.append("'").append(this.externalKey).append("'");
        }
        sb.append(", ");
        sb.append("subscriptionEvents=").append(this.subscriptionEvents);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected UUID accountId;
        protected UUID bundleId;
        protected String externalKey;
        protected List<SubscriptionEvent> subscriptionEvents;

        public Builder() {
        }

        public Builder(Builder that) {
            this.accountId = that.accountId;
            this.bundleId = that.bundleId;
            this.externalKey = that.externalKey;
            this.subscriptionEvents = that.subscriptionEvents;
        }

        public T withAccountId(UUID accountId) {
            this.accountId = accountId;
            return (T)this;
        }

        public T withBundleId(UUID bundleId) {
            this.bundleId = bundleId;
            return (T)this;
        }

        public T withExternalKey(String externalKey) {
            this.externalKey = externalKey;
            return (T)this;
        }

        public T withSubscriptionEvents(List<SubscriptionEvent> subscriptionEvents) {
            this.subscriptionEvents = subscriptionEvents;
            return (T)this;
        }

        public T source(SubscriptionBundleTimeline that) {
            this.accountId = that.getAccountId();
            this.bundleId = that.getBundleId();
            this.externalKey = that.getExternalKey();
            this.subscriptionEvents = that.getSubscriptionEvents();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public SubscriptionBundleTimelineImp build() {
            return new SubscriptionBundleTimelineImp(this.validate());
        }
    }
}

