/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.entitlement.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Objects;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.entitlement.api.EntitlementSpecifier;

@JsonDeserialize(builder=Builder.class)
public class EntitlementSpecifierImp
implements EntitlementSpecifier {
    protected Integer billCycleDay;
    protected String externalKey;
    protected List<PlanPhasePriceOverride> overrides;
    protected PlanPhaseSpecifier planPhaseSpecifier;
    protected Integer quantity;

    public EntitlementSpecifierImp(EntitlementSpecifierImp that) {
        this.billCycleDay = that.billCycleDay;
        this.externalKey = that.externalKey;
        this.overrides = that.overrides;
        this.planPhaseSpecifier = that.planPhaseSpecifier;
        this.quantity = that.quantity;
    }

    protected EntitlementSpecifierImp(Builder<?> builder) {
        this.billCycleDay = builder.billCycleDay;
        this.externalKey = builder.externalKey;
        this.overrides = builder.overrides;
        this.planPhaseSpecifier = builder.planPhaseSpecifier;
        this.quantity = builder.quantity;
    }

    protected EntitlementSpecifierImp() {
    }

    public Integer getBillCycleDay() {
        return this.billCycleDay;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public List<PlanPhasePriceOverride> getOverrides() {
        return this.overrides;
    }

    public PlanPhaseSpecifier getPlanPhaseSpecifier() {
        return this.planPhaseSpecifier;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntitlementSpecifierImp that = (EntitlementSpecifierImp)o;
        if (!Objects.equals(this.billCycleDay, that.billCycleDay)) {
            return false;
        }
        if (!Objects.equals(this.externalKey, that.externalKey)) {
            return false;
        }
        if (!Objects.equals(this.overrides, that.overrides)) {
            return false;
        }
        if (!Objects.equals(this.planPhaseSpecifier, that.planPhaseSpecifier)) {
            return false;
        }
        return Objects.equals(this.quantity, that.quantity);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.billCycleDay);
        result = 31 * result + Objects.hashCode(this.externalKey);
        result = 31 * result + Objects.hashCode(this.overrides);
        result = 31 * result + Objects.hashCode(this.planPhaseSpecifier);
        result = 31 * result + Objects.hashCode(this.quantity);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("billCycleDay=").append(this.billCycleDay);
        sb.append(", ");
        sb.append("externalKey=");
        if (this.externalKey == null) {
            sb.append(this.externalKey);
        } else {
            sb.append("'").append(this.externalKey).append("'");
        }
        sb.append(", ");
        sb.append("overrides=").append(this.overrides);
        sb.append(", ");
        sb.append("planPhaseSpecifier=").append(this.planPhaseSpecifier);
        sb.append(", ");
        sb.append("quantity=").append(this.quantity);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected Integer billCycleDay;
        protected String externalKey;
        protected List<PlanPhasePriceOverride> overrides;
        protected PlanPhaseSpecifier planPhaseSpecifier;
        protected Integer quantity;

        public Builder() {
        }

        public Builder(Builder that) {
            this.billCycleDay = that.billCycleDay;
            this.externalKey = that.externalKey;
            this.overrides = that.overrides;
            this.planPhaseSpecifier = that.planPhaseSpecifier;
            this.quantity = that.quantity;
        }

        public T withBillCycleDay(Integer billCycleDay) {
            this.billCycleDay = billCycleDay;
            return (T)this;
        }

        public T withExternalKey(String externalKey) {
            this.externalKey = externalKey;
            return (T)this;
        }

        public T withOverrides(List<PlanPhasePriceOverride> overrides) {
            this.overrides = overrides;
            return (T)this;
        }

        public T withPlanPhaseSpecifier(PlanPhaseSpecifier planPhaseSpecifier) {
            this.planPhaseSpecifier = planPhaseSpecifier;
            return (T)this;
        }

        public T withQuantity(Integer quantity) {
            this.quantity = quantity;
            return (T)this;
        }

        public T source(EntitlementSpecifier that) {
            this.billCycleDay = that.getBillCycleDay();
            this.externalKey = that.getExternalKey();
            this.overrides = that.getOverrides();
            this.planPhaseSpecifier = that.getPlanPhaseSpecifier();
            this.quantity = that.getQuantity();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public EntitlementSpecifierImp build() {
            return new EntitlementSpecifierImp(this.validate());
        }
    }
}

