/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api.rules.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.rules.CasePriceList;

@JsonDeserialize(builder=Builder.class)
public class CasePriceListImp
implements CasePriceList {
    protected BillingPeriod billingPeriod;
    protected StaticCatalog catalog;
    protected PriceList destinationPriceList;
    protected PriceList priceList;
    protected Product product;
    protected ProductCategory productCategory;

    public CasePriceListImp(CasePriceListImp that) {
        this.billingPeriod = that.billingPeriod;
        this.catalog = that.catalog;
        this.destinationPriceList = that.destinationPriceList;
        this.priceList = that.priceList;
        this.product = that.product;
        this.productCategory = that.productCategory;
    }

    protected CasePriceListImp(Builder<?> builder) {
        this.billingPeriod = builder.billingPeriod;
        this.catalog = builder.catalog;
        this.destinationPriceList = builder.destinationPriceList;
        this.priceList = builder.priceList;
        this.product = builder.product;
        this.productCategory = builder.productCategory;
    }

    protected CasePriceListImp() {
    }

    public BillingPeriod getBillingPeriod() {
        return this.billingPeriod;
    }

    public StaticCatalog getCatalog() {
        return this.catalog;
    }

    public PriceList getDestinationPriceList() {
        return this.destinationPriceList;
    }

    public PriceList getPriceList() {
        return this.priceList;
    }

    public Product getProduct() {
        return this.product;
    }

    public ProductCategory getProductCategory() {
        return this.productCategory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CasePriceListImp that = (CasePriceListImp)o;
        if (!Objects.equals(this.billingPeriod, that.billingPeriod)) {
            return false;
        }
        if (!Objects.equals(this.catalog, that.catalog)) {
            return false;
        }
        if (!Objects.equals(this.destinationPriceList, that.destinationPriceList)) {
            return false;
        }
        if (!Objects.equals(this.priceList, that.priceList)) {
            return false;
        }
        if (!Objects.equals(this.product, that.product)) {
            return false;
        }
        return Objects.equals(this.productCategory, that.productCategory);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.billingPeriod);
        result = 31 * result + Objects.hashCode(this.catalog);
        result = 31 * result + Objects.hashCode(this.destinationPriceList);
        result = 31 * result + Objects.hashCode(this.priceList);
        result = 31 * result + Objects.hashCode(this.product);
        result = 31 * result + Objects.hashCode(this.productCategory);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("billingPeriod=").append(this.billingPeriod);
        sb.append(", ");
        sb.append("catalog=").append(this.catalog);
        sb.append(", ");
        sb.append("destinationPriceList=").append(this.destinationPriceList);
        sb.append(", ");
        sb.append("priceList=").append(this.priceList);
        sb.append(", ");
        sb.append("product=").append(this.product);
        sb.append(", ");
        sb.append("productCategory=").append(this.productCategory);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected BillingPeriod billingPeriod;
        protected StaticCatalog catalog;
        protected PriceList destinationPriceList;
        protected PriceList priceList;
        protected Product product;
        protected ProductCategory productCategory;

        public Builder() {
        }

        public Builder(Builder that) {
            this.billingPeriod = that.billingPeriod;
            this.catalog = that.catalog;
            this.destinationPriceList = that.destinationPriceList;
            this.priceList = that.priceList;
            this.product = that.product;
            this.productCategory = that.productCategory;
        }

        public T withBillingPeriod(BillingPeriod billingPeriod) {
            this.billingPeriod = billingPeriod;
            return (T)this;
        }

        public T withCatalog(StaticCatalog catalog) {
            this.catalog = catalog;
            return (T)this;
        }

        public T withDestinationPriceList(PriceList destinationPriceList) {
            this.destinationPriceList = destinationPriceList;
            return (T)this;
        }

        public T withPriceList(PriceList priceList) {
            this.priceList = priceList;
            return (T)this;
        }

        public T withProduct(Product product) {
            this.product = product;
            return (T)this;
        }

        public T withProductCategory(ProductCategory productCategory) {
            this.productCategory = productCategory;
            return (T)this;
        }

        public T source(CasePriceList that) {
            this.billingPeriod = that.getBillingPeriod();
            this.catalog = that.getCatalog();
            this.destinationPriceList = that.getDestinationPriceList();
            this.priceList = that.getPriceList();
            this.product = that.getProduct();
            this.productCategory = that.getProductCategory();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public CasePriceListImp build() {
            return new CasePriceListImp(this.validate());
        }
    }
}

