/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Objects;
import org.killbill.billing.catalog.api.TierPriceOverride;
import org.killbill.billing.catalog.api.UsagePriceOverride;
import org.killbill.billing.catalog.api.UsageType;

@JsonDeserialize(builder=Builder.class)
public class UsagePriceOverrideImp
implements UsagePriceOverride {
    protected String name;
    protected List<TierPriceOverride> tierPriceOverrides;
    protected UsageType usageType;

    public UsagePriceOverrideImp(UsagePriceOverrideImp that) {
        this.name = that.name;
        this.tierPriceOverrides = that.tierPriceOverrides;
        this.usageType = that.usageType;
    }

    protected UsagePriceOverrideImp(Builder<?> builder) {
        this.name = builder.name;
        this.tierPriceOverrides = builder.tierPriceOverrides;
        this.usageType = builder.usageType;
    }

    protected UsagePriceOverrideImp() {
    }

    public String getName() {
        return this.name;
    }

    public List<TierPriceOverride> getTierPriceOverrides() {
        return this.tierPriceOverrides;
    }

    public UsageType getUsageType() {
        return this.usageType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsagePriceOverrideImp that = (UsagePriceOverrideImp)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.tierPriceOverrides, that.tierPriceOverrides)) {
            return false;
        }
        return Objects.equals(this.usageType, that.usageType);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.tierPriceOverrides);
        result = 31 * result + Objects.hashCode(this.usageType);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("name=");
        if (this.name == null) {
            sb.append(this.name);
        } else {
            sb.append("'").append(this.name).append("'");
        }
        sb.append(", ");
        sb.append("tierPriceOverrides=").append(this.tierPriceOverrides);
        sb.append(", ");
        sb.append("usageType=").append(this.usageType);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected String name;
        protected List<TierPriceOverride> tierPriceOverrides;
        protected UsageType usageType;

        public Builder() {
        }

        public Builder(Builder that) {
            this.name = that.name;
            this.tierPriceOverrides = that.tierPriceOverrides;
            this.usageType = that.usageType;
        }

        public T withName(String name) {
            this.name = name;
            return (T)this;
        }

        public T withTierPriceOverrides(List<TierPriceOverride> tierPriceOverrides) {
            this.tierPriceOverrides = tierPriceOverrides;
            return (T)this;
        }

        public T withUsageType(UsageType usageType) {
            this.usageType = usageType;
            return (T)this;
        }

        public T source(UsagePriceOverride that) {
            this.name = that.getName();
            this.tierPriceOverrides = that.getTierPriceOverrides();
            this.usageType = that.getUsageType();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public UsagePriceOverrideImp build() {
            return new UsagePriceOverrideImp(this.validate());
        }
    }
}

