/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.killbill.billing.catalog.api.Limit;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.catalog.api.StaticCatalog;

@JsonDeserialize(builder=Builder.class)
public class ProductImp
implements Product {
    protected Collection<Product> available;
    protected StaticCatalog catalog;
    protected String catalogName;
    protected ProductCategory category;
    protected Collection<Product> included;
    protected Limit[] limits;
    protected String name;
    protected String prettyName;

    public ProductImp(ProductImp that) {
        this.available = that.available;
        this.catalog = that.catalog;
        this.catalogName = that.catalogName;
        this.category = that.category;
        this.included = that.included;
        this.limits = that.limits;
        this.name = that.name;
        this.prettyName = that.prettyName;
    }

    protected ProductImp(Builder<?> builder) {
        this.available = builder.available;
        this.catalog = builder.catalog;
        this.catalogName = builder.catalogName;
        this.category = builder.category;
        this.included = builder.included;
        this.limits = builder.limits;
        this.name = builder.name;
        this.prettyName = builder.prettyName;
    }

    protected ProductImp() {
    }

    public Collection<Product> getAvailable() {
        return this.available;
    }

    public StaticCatalog getCatalog() {
        return this.catalog;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public ProductCategory getCategory() {
        return this.category;
    }

    public Collection<Product> getIncluded() {
        return this.included;
    }

    public Limit[] getLimits() {
        return this.limits;
    }

    public String getName() {
        return this.name;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public boolean compliesWithLimits(String unit, BigDecimal value) {
        throw new UnsupportedOperationException("compliesWithLimits(java.lang.String, java.math.BigDecimal) must be implemented.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductImp that = (ProductImp)o;
        if (!Objects.equals(this.available, that.available)) {
            return false;
        }
        if (!Objects.equals(this.catalog, that.catalog)) {
            return false;
        }
        if (!Objects.equals(this.catalogName, that.catalogName)) {
            return false;
        }
        if (!Objects.equals(this.category, that.category)) {
            return false;
        }
        if (!Objects.equals(this.included, that.included)) {
            return false;
        }
        if (!Arrays.deepEquals(this.limits, that.limits)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.prettyName, that.prettyName);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.available);
        result = 31 * result + Objects.hashCode(this.catalog);
        result = 31 * result + Objects.hashCode(this.catalogName);
        result = 31 * result + Objects.hashCode(this.category);
        result = 31 * result + Objects.hashCode(this.included);
        result = 31 * result + Arrays.deepHashCode(this.limits);
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.prettyName);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("available=").append(this.available);
        sb.append(", ");
        sb.append("catalog=").append(this.catalog);
        sb.append(", ");
        sb.append("catalogName=");
        if (this.catalogName == null) {
            sb.append(this.catalogName);
        } else {
            sb.append("'").append(this.catalogName).append("'");
        }
        sb.append(", ");
        sb.append("category=").append(this.category);
        sb.append(", ");
        sb.append("included=").append(this.included);
        sb.append(", ");
        sb.append("limits=").append(Arrays.toString(this.limits));
        sb.append(", ");
        sb.append("name=");
        if (this.name == null) {
            sb.append(this.name);
        } else {
            sb.append("'").append(this.name).append("'");
        }
        sb.append(", ");
        sb.append("prettyName=");
        if (this.prettyName == null) {
            sb.append(this.prettyName);
        } else {
            sb.append("'").append(this.prettyName).append("'");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected Collection<Product> available;
        protected StaticCatalog catalog;
        protected String catalogName;
        protected ProductCategory category;
        protected Collection<Product> included;
        protected Limit[] limits;
        protected String name;
        protected String prettyName;

        public Builder() {
        }

        public Builder(Builder that) {
            this.available = that.available;
            this.catalog = that.catalog;
            this.catalogName = that.catalogName;
            this.category = that.category;
            this.included = that.included;
            this.limits = that.limits;
            this.name = that.name;
            this.prettyName = that.prettyName;
        }

        public T withAvailable(Collection<Product> available) {
            this.available = available;
            return (T)this;
        }

        public T withCatalog(StaticCatalog catalog) {
            this.catalog = catalog;
            return (T)this;
        }

        public T withCatalogName(String catalogName) {
            this.catalogName = catalogName;
            return (T)this;
        }

        public T withCategory(ProductCategory category) {
            this.category = category;
            return (T)this;
        }

        public T withIncluded(Collection<Product> included) {
            this.included = included;
            return (T)this;
        }

        public T withLimits(Limit[] limits) {
            this.limits = limits;
            return (T)this;
        }

        public T withName(String name) {
            this.name = name;
            return (T)this;
        }

        public T withPrettyName(String prettyName) {
            this.prettyName = prettyName;
            return (T)this;
        }

        public T source(Product that) {
            this.available = that.getAvailable();
            this.catalog = that.getCatalog();
            this.catalogName = that.getCatalogName();
            this.category = that.getCategory();
            this.included = that.getIncluded();
            this.limits = that.getLimits();
            this.name = that.getName();
            this.prettyName = that.getPrettyName();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public ProductImp build() {
            return new ProductImp(this.validate());
        }
    }
}

