/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Objects;
import org.joda.time.DateTime;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.MigrationPlan;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.StaticCatalog;

@JsonDeserialize(builder=Builder.class)
public class MigrationPlanImp
implements MigrationPlan {
    protected PlanPhase[] allPhases;
    protected StaticCatalog catalog;
    protected Date effectiveDateForExistingSubscriptions;
    protected PlanPhase finalPhase;
    protected Iterator<PlanPhase> initialPhaseIterator;
    protected PlanPhase[] initialPhases;
    protected String name;
    protected int plansAllowedInBundle;
    protected String prettyName;
    protected PriceList priceList;
    protected Product product;
    protected BillingMode recurringBillingMode;
    protected BillingPeriod recurringBillingPeriod;

    public MigrationPlanImp(MigrationPlanImp that) {
        this.allPhases = that.allPhases;
        this.catalog = that.catalog;
        this.effectiveDateForExistingSubscriptions = that.effectiveDateForExistingSubscriptions;
        this.finalPhase = that.finalPhase;
        this.initialPhaseIterator = that.initialPhaseIterator;
        this.initialPhases = that.initialPhases;
        this.name = that.name;
        this.plansAllowedInBundle = that.plansAllowedInBundle;
        this.prettyName = that.prettyName;
        this.priceList = that.priceList;
        this.product = that.product;
        this.recurringBillingMode = that.recurringBillingMode;
        this.recurringBillingPeriod = that.recurringBillingPeriod;
    }

    protected MigrationPlanImp(Builder<?> builder) {
        this.allPhases = builder.allPhases;
        this.catalog = builder.catalog;
        this.effectiveDateForExistingSubscriptions = builder.effectiveDateForExistingSubscriptions;
        this.finalPhase = builder.finalPhase;
        this.initialPhaseIterator = builder.initialPhaseIterator;
        this.initialPhases = builder.initialPhases;
        this.name = builder.name;
        this.plansAllowedInBundle = builder.plansAllowedInBundle;
        this.prettyName = builder.prettyName;
        this.priceList = builder.priceList;
        this.product = builder.product;
        this.recurringBillingMode = builder.recurringBillingMode;
        this.recurringBillingPeriod = builder.recurringBillingPeriod;
    }

    protected MigrationPlanImp() {
    }

    public PlanPhase[] getAllPhases() {
        return this.allPhases;
    }

    public StaticCatalog getCatalog() {
        return this.catalog;
    }

    public Date getEffectiveDateForExistingSubscriptions() {
        return this.effectiveDateForExistingSubscriptions;
    }

    public PlanPhase getFinalPhase() {
        return this.finalPhase;
    }

    public Iterator<PlanPhase> getInitialPhaseIterator() {
        return this.initialPhaseIterator;
    }

    public PlanPhase[] getInitialPhases() {
        return this.initialPhases;
    }

    public String getName() {
        return this.name;
    }

    public int getPlansAllowedInBundle() {
        return this.plansAllowedInBundle;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public PriceList getPriceList() {
        return this.priceList;
    }

    public Product getProduct() {
        return this.product;
    }

    public BillingMode getRecurringBillingMode() {
        return this.recurringBillingMode;
    }

    public BillingPeriod getRecurringBillingPeriod() {
        return this.recurringBillingPeriod;
    }

    public DateTime dateOfFirstRecurringNonZeroCharge(DateTime subscriptionStartDate, PhaseType intialPhaseType) {
        throw new UnsupportedOperationException("dateOfFirstRecurringNonZeroCharge(org.joda.time.DateTime, org.killbill.billing.catalog.api.PhaseType) must be implemented.");
    }

    public PlanPhase findPhase(String name) {
        throw new UnsupportedOperationException("findPhase(java.lang.String) must be implemented.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationPlanImp that = (MigrationPlanImp)o;
        if (!Arrays.deepEquals(this.allPhases, that.allPhases)) {
            return false;
        }
        if (!Objects.equals(this.catalog, that.catalog)) {
            return false;
        }
        if (!Objects.equals(this.effectiveDateForExistingSubscriptions, that.effectiveDateForExistingSubscriptions)) {
            return false;
        }
        if (!Objects.equals(this.finalPhase, that.finalPhase)) {
            return false;
        }
        if (!Objects.equals(this.initialPhaseIterator, that.initialPhaseIterator)) {
            return false;
        }
        if (!Arrays.deepEquals(this.initialPhases, that.initialPhases)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (this.plansAllowedInBundle != that.plansAllowedInBundle) {
            return false;
        }
        if (!Objects.equals(this.prettyName, that.prettyName)) {
            return false;
        }
        if (!Objects.equals(this.priceList, that.priceList)) {
            return false;
        }
        if (!Objects.equals(this.product, that.product)) {
            return false;
        }
        if (!Objects.equals(this.recurringBillingMode, that.recurringBillingMode)) {
            return false;
        }
        return Objects.equals(this.recurringBillingPeriod, that.recurringBillingPeriod);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.deepHashCode(this.allPhases);
        result = 31 * result + Objects.hashCode(this.catalog);
        result = 31 * result + Objects.hashCode(this.effectiveDateForExistingSubscriptions);
        result = 31 * result + Objects.hashCode(this.finalPhase);
        result = 31 * result + Objects.hashCode(this.initialPhaseIterator);
        result = 31 * result + Arrays.deepHashCode(this.initialPhases);
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.plansAllowedInBundle);
        result = 31 * result + Objects.hashCode(this.prettyName);
        result = 31 * result + Objects.hashCode(this.priceList);
        result = 31 * result + Objects.hashCode(this.product);
        result = 31 * result + Objects.hashCode(this.recurringBillingMode);
        result = 31 * result + Objects.hashCode(this.recurringBillingPeriod);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("allPhases=").append(Arrays.toString(this.allPhases));
        sb.append(", ");
        sb.append("catalog=").append(this.catalog);
        sb.append(", ");
        sb.append("effectiveDateForExistingSubscriptions=").append(this.effectiveDateForExistingSubscriptions);
        sb.append(", ");
        sb.append("finalPhase=").append(this.finalPhase);
        sb.append(", ");
        sb.append("initialPhaseIterator=").append(this.initialPhaseIterator);
        sb.append(", ");
        sb.append("initialPhases=").append(Arrays.toString(this.initialPhases));
        sb.append(", ");
        sb.append("name=");
        if (this.name == null) {
            sb.append(this.name);
        } else {
            sb.append("'").append(this.name).append("'");
        }
        sb.append(", ");
        sb.append("plansAllowedInBundle=").append(this.plansAllowedInBundle);
        sb.append(", ");
        sb.append("prettyName=");
        if (this.prettyName == null) {
            sb.append(this.prettyName);
        } else {
            sb.append("'").append(this.prettyName).append("'");
        }
        sb.append(", ");
        sb.append("priceList=").append(this.priceList);
        sb.append(", ");
        sb.append("product=").append(this.product);
        sb.append(", ");
        sb.append("recurringBillingMode=").append(this.recurringBillingMode);
        sb.append(", ");
        sb.append("recurringBillingPeriod=").append(this.recurringBillingPeriod);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected PlanPhase[] allPhases;
        protected StaticCatalog catalog;
        protected Date effectiveDateForExistingSubscriptions;
        protected PlanPhase finalPhase;
        protected Iterator<PlanPhase> initialPhaseIterator;
        protected PlanPhase[] initialPhases;
        protected String name;
        protected int plansAllowedInBundle;
        protected String prettyName;
        protected PriceList priceList;
        protected Product product;
        protected BillingMode recurringBillingMode;
        protected BillingPeriod recurringBillingPeriod;

        public Builder() {
        }

        public Builder(Builder that) {
            this.allPhases = that.allPhases;
            this.catalog = that.catalog;
            this.effectiveDateForExistingSubscriptions = that.effectiveDateForExistingSubscriptions;
            this.finalPhase = that.finalPhase;
            this.initialPhaseIterator = that.initialPhaseIterator;
            this.initialPhases = that.initialPhases;
            this.name = that.name;
            this.plansAllowedInBundle = that.plansAllowedInBundle;
            this.prettyName = that.prettyName;
            this.priceList = that.priceList;
            this.product = that.product;
            this.recurringBillingMode = that.recurringBillingMode;
            this.recurringBillingPeriod = that.recurringBillingPeriod;
        }

        public T withAllPhases(PlanPhase[] allPhases) {
            this.allPhases = allPhases;
            return (T)this;
        }

        public T withCatalog(StaticCatalog catalog) {
            this.catalog = catalog;
            return (T)this;
        }

        public T withEffectiveDateForExistingSubscriptions(Date effectiveDateForExistingSubscriptions) {
            this.effectiveDateForExistingSubscriptions = effectiveDateForExistingSubscriptions;
            return (T)this;
        }

        public T withFinalPhase(PlanPhase finalPhase) {
            this.finalPhase = finalPhase;
            return (T)this;
        }

        public T withInitialPhaseIterator(Iterator<PlanPhase> initialPhaseIterator) {
            this.initialPhaseIterator = initialPhaseIterator;
            return (T)this;
        }

        public T withInitialPhases(PlanPhase[] initialPhases) {
            this.initialPhases = initialPhases;
            return (T)this;
        }

        public T withName(String name) {
            this.name = name;
            return (T)this;
        }

        public T withPlansAllowedInBundle(int plansAllowedInBundle) {
            this.plansAllowedInBundle = plansAllowedInBundle;
            return (T)this;
        }

        public T withPrettyName(String prettyName) {
            this.prettyName = prettyName;
            return (T)this;
        }

        public T withPriceList(PriceList priceList) {
            this.priceList = priceList;
            return (T)this;
        }

        public T withProduct(Product product) {
            this.product = product;
            return (T)this;
        }

        public T withRecurringBillingMode(BillingMode recurringBillingMode) {
            this.recurringBillingMode = recurringBillingMode;
            return (T)this;
        }

        public T withRecurringBillingPeriod(BillingPeriod recurringBillingPeriod) {
            this.recurringBillingPeriod = recurringBillingPeriod;
            return (T)this;
        }

        public T source(MigrationPlan that) {
            this.allPhases = that.getAllPhases();
            this.catalog = that.getCatalog();
            this.effectiveDateForExistingSubscriptions = that.getEffectiveDateForExistingSubscriptions();
            this.finalPhase = that.getFinalPhase();
            this.initialPhaseIterator = that.getInitialPhaseIterator();
            this.initialPhases = that.getInitialPhases();
            this.name = that.getName();
            this.plansAllowedInBundle = that.getPlansAllowedInBundle();
            this.prettyName = that.getPrettyName();
            this.priceList = that.getPriceList();
            this.product = that.getProduct();
            this.recurringBillingMode = that.getRecurringBillingMode();
            this.recurringBillingPeriod = that.getRecurringBillingPeriod();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public MigrationPlanImp build() {
            return new MigrationPlanImp(this.validate());
        }
    }
}

