/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api.boilerplate;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.Objects;
import org.killbill.billing.catalog.api.Limit;
import org.killbill.billing.catalog.api.Unit;

@JsonDeserialize(builder=Builder.class)
public class LimitImp
implements Limit {
    protected BigDecimal max;
    protected BigDecimal min;
    protected Unit unit;

    public LimitImp(LimitImp that) {
        this.max = that.max;
        this.min = that.min;
        this.unit = that.unit;
    }

    protected LimitImp(Builder<?> builder) {
        this.max = builder.max;
        this.min = builder.min;
        this.unit = builder.unit;
    }

    protected LimitImp() {
    }

    public BigDecimal getMax() {
        return this.max;
    }

    public BigDecimal getMin() {
        return this.min;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public boolean compliesWith(BigDecimal value) {
        throw new UnsupportedOperationException("compliesWith(java.math.BigDecimal) must be implemented.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LimitImp that = (LimitImp)o;
        if (!Objects.equals(this.max, that.max)) {
            return false;
        }
        if (!Objects.equals(this.min, that.min)) {
            return false;
        }
        return Objects.equals(this.unit, that.unit);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.max);
        result = 31 * result + Objects.hashCode(this.min);
        result = 31 * result + Objects.hashCode(this.unit);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("max=").append(this.max);
        sb.append(", ");
        sb.append("min=").append(this.min);
        sb.append(", ");
        sb.append("unit=").append(this.unit);
        sb.append("}");
        return sb.toString();
    }

    public static class Builder<T extends Builder<T>> {
        protected BigDecimal max;
        protected BigDecimal min;
        protected Unit unit;

        public Builder() {
        }

        public Builder(Builder that) {
            this.max = that.max;
            this.min = that.min;
            this.unit = that.unit;
        }

        public T withMax(BigDecimal max) {
            this.max = max;
            return (T)this;
        }

        public T withMin(BigDecimal min2) {
            this.min = min2;
            return (T)this;
        }

        public T withUnit(Unit unit) {
            this.unit = unit;
            return (T)this;
        }

        public T source(Limit that) {
            this.max = that.getMax();
            this.min = that.getMin();
            this.unit = that.getUnit();
            return (T)this;
        }

        protected Builder validate() {
            return this;
        }

        public LimitImp build() {
            return new LimitImp(this.validate());
        }
    }
}

