/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.Truncate;
import org.jooq.TruncateCascadeStep;
import org.jooq.TruncateFinalStep;
import org.jooq.TruncateIdentityStep;
import org.jooq.impl.AbstractDDLQuery;
import org.jooq.impl.Cascade;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;

final class TruncateImpl<R extends Record>
extends AbstractDDLQuery
implements TruncateIdentityStep<R>,
TruncateCascadeStep<R>,
TruncateFinalStep<R>,
Truncate<R> {
    private final Table<R> table;
    private Boolean restartIdentity;
    private Cascade cascade;
    private static final Clause[] CLAUSES = new Clause[]{Clause.TRUNCATE};

    TruncateImpl(Configuration configuration, Table<R> table) {
        this(configuration, table, null, null);
    }

    TruncateImpl(Configuration configuration, Table<R> table, Boolean restartIdentity, Cascade cascade) {
        super(configuration);
        this.table = table;
        this.restartIdentity = restartIdentity;
        this.cascade = cascade;
    }

    final Table<R> $table() {
        return this.table;
    }

    final Boolean $restartIdentity() {
        return this.restartIdentity;
    }

    final Cascade $cascade() {
        return this.cascade;
    }

    @Override
    public final TruncateImpl<R> restartIdentity() {
        this.restartIdentity = true;
        return this;
    }

    @Override
    public final TruncateImpl<R> continueIdentity() {
        this.restartIdentity = false;
        return this;
    }

    @Override
    public final TruncateImpl<R> cascade() {
        this.cascade = Cascade.CASCADE;
        return this;
    }

    @Override
    public final TruncateImpl<R> restrict() {
        this.cascade = Cascade.RESTRICT;
        return this;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: 
            case IGNITE: 
            case SQLITE: {
                ctx.visit(DSL.delete(this.table));
                break;
            }
            default: {
                ctx.start(Clause.TRUNCATE_TRUNCATE).visit(Keywords.K_TRUNCATE).sql(' ').visit(Keywords.K_TABLE).sql(' ').visit(this.table);
                if (this.restartIdentity != null) {
                    ctx.formatSeparator().visit(this.restartIdentity != false ? Keywords.K_RESTART_IDENTITY : Keywords.K_CONTINUE_IDENTITY);
                }
                if (this.cascade != null) {
                    ctx.formatSeparator().visit(this.cascade == Cascade.CASCADE ? Keywords.K_CASCADE : Keywords.K_RESTRICT);
                }
                ctx.end(Clause.TRUNCATE_TRUNCATE);
            }
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

