/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class Substring
extends AbstractField<String> {
    private final Field<String> string;
    private final Field<? extends Number> startingPosition;
    private final Field<? extends Number> length;

    Substring(Field<String> string, Field<? extends Number> startingPosition) {
        super(Names.N_SUBSTRING, Tools.allNotNull(SQLDataType.VARCHAR, string, startingPosition));
        this.string = Tools.nullSafeNotNull(string, SQLDataType.VARCHAR);
        this.startingPosition = Tools.nullSafeNotNull(startingPosition, SQLDataType.INTEGER);
        this.length = null;
    }

    Substring(Field<String> string, Field<? extends Number> startingPosition, Field<? extends Number> length) {
        super(Names.N_SUBSTRING, Tools.allNotNull(SQLDataType.VARCHAR, string, startingPosition, length));
        this.string = Tools.nullSafeNotNull(string, SQLDataType.VARCHAR);
        this.startingPosition = Tools.nullSafeNotNull(startingPosition, SQLDataType.INTEGER);
        this.length = Tools.nullSafeNotNull(length, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        Name functionName = Names.N_SUBSTRING;
        switch (ctx.family()) {
            case FIREBIRD: {
                if (this.length == null) {
                    ctx.visit(Names.N_SUBSTRING).sql('(').visit(this.string).sql(' ').visit(Keywords.K_FROM).sql(' ').visit(this.startingPosition).sql(')');
                } else {
                    ctx.visit(Names.N_SUBSTRING).sql('(').visit(this.string).sql(' ').visit(Keywords.K_FROM).sql(' ').visit(this.startingPosition).sql(' ').visit(Keywords.K_FOR).sql(' ').visit(this.length).sql(')');
                }
                return;
            }
            case DERBY: 
            case SQLITE: {
                functionName = Names.N_SUBSTR;
            }
        }
        if (this.length == null) {
            ctx.visit(DSL.function(functionName, this.getDataType(), this.string, this.startingPosition));
        } else {
            ctx.visit(DSL.function(functionName, this.getDataType(), this.string, this.startingPosition, this.length));
        }
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof Substring) {
            return StringUtils.equals(this.string, ((Substring)that).string) && StringUtils.equals(this.startingPosition, ((Substring)that).startingPosition) && StringUtils.equals(this.length, ((Substring)that).length);
        }
        return super.equals(that);
    }
}

