/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class Right
extends AbstractField<String> {
    private final Field<String> string;
    private final Field<? extends Number> length;

    Right(Field<String> string, Field<? extends Number> length) {
        super(Names.N_RIGHT, Tools.allNotNull(SQLDataType.VARCHAR, string, length));
        this.string = Tools.nullSafeNotNull(string, SQLDataType.VARCHAR);
        this.length = Tools.nullSafeNotNull(length, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: {
                ctx.visit(DSL.substring(this.string, Internal.iadd(DSL.length(this.string), Internal.isub(DSL.one(), this.length))));
                break;
            }
            case SQLITE: {
                ctx.visit(DSL.substring(this.string, Internal.ineg(this.length)));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_RIGHT, this.getDataType(), this.string, this.length));
            }
        }
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof Right) {
            return StringUtils.equals(this.string, ((Right)that).string) && StringUtils.equals(this.length, ((Right)that).length);
        }
        return super.equals(that);
    }
}

