/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Name;
import org.jooq.impl.AbstractWindowFunction;
import org.jooq.impl.DSL;

final class RankingFunction<T>
extends AbstractWindowFunction<T> {
    private final RankingType rankingType;

    RankingFunction(RankingType rankingType, DataType<T> type) {
        super(rankingType.name, type.notNull());
        this.rankingType = rankingType;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.rankingType.name).sql("()");
        this.acceptOverClause(ctx);
    }

    final boolean isRankOrDenseRank() {
        return this.rankingType == RankingType.RANK || this.rankingType == RankingType.DENSE_RANK;
    }

    static enum RankingType {
        RANK,
        DENSE_RANK,
        PERCENT_RANK,
        CUME_DIST;

        private final Name name = DSL.unquotedName(this.name().toLowerCase());
    }
}

