/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigDecimal;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class Radians
extends AbstractField<BigDecimal> {
    private final Field<? extends Number> degrees;

    Radians(Field<? extends Number> degrees2) {
        super(Names.N_RADIANS, Tools.allNotNull(SQLDataType.NUMERIC, degrees2));
        this.degrees = Tools.nullSafeNotNull(degrees2, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: 
            case SQLITE: {
                ctx.visit(Internal.idiv(Internal.imul(Tools.castIfNeeded(this.degrees, BigDecimal.class), DSL.pi()), DSL.inline(180)));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_RADIANS, this.getDataType(), this.degrees));
            }
        }
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof Radians) {
            return StringUtils.equals(this.degrees, ((Radians)that).degrees);
        }
        return super.equals(that);
    }
}

