/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigDecimal;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class Power
extends AbstractField<BigDecimal> {
    private final Field<? extends Number> value;
    private final Field<? extends Number> exponent;

    Power(Field<? extends Number> value, Field<? extends Number> exponent) {
        super(Names.N_POWER, Tools.allNotNull(SQLDataType.NUMERIC, value, exponent));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.INTEGER);
        this.exponent = Tools.nullSafeNotNull(exponent, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: 
            case SQLITE: {
                ctx.visit(DSL.exp(Internal.imul(DSL.ln(this.value), this.exponent)));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_POWER, this.getDataType(), this.value, this.exponent));
            }
        }
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof Power) {
            return StringUtils.equals(this.value, ((Power)that).value) && StringUtils.equals(this.exponent, ((Power)that).exponent);
        }
        return super.equals(that);
    }
}

