/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.SQLDialect;
import org.jooq.conf.TransformUnneededArithmeticExpressions;
import org.jooq.impl.AbstractTransformable;
import org.jooq.impl.DSL;
import org.jooq.impl.ExpressionOperator;
import org.jooq.impl.Internal;
import org.jooq.impl.Names;

final class Neg<T>
extends AbstractTransformable<T> {
    private static final Set<SQLDialect> EMULATE_BIT_NOT = SQLDialect.supportedBy(SQLDialect.HSQLDB);
    private static final Set<SQLDialect> SUPPORT_BIT_NOT = SQLDialect.supportedBy(SQLDialect.H2);
    private final Field<T> field;
    private final boolean internal;
    private final ExpressionOperator operator;

    Neg(Field<T> field, boolean internal, ExpressionOperator operator) {
        super(operator.toName(), field.getDataType());
        this.field = field;
        this.internal = internal;
        this.operator = operator;
    }

    @Override
    public final Field<?> transform(TransformUnneededArithmeticExpressions transform) {
        return this;
    }

    @Override
    public final void accept0(Context<?> ctx) {
        SQLDialect family = ctx.family();
        if (this.operator == ExpressionOperator.BIT_NOT && EMULATE_BIT_NOT.contains((Object)ctx.dialect())) {
            ctx.visit(Internal.isub(Internal.isub(DSL.zero(), this.field), DSL.one()));
        } else if (this.operator == ExpressionOperator.BIT_NOT && SUPPORT_BIT_NOT.contains((Object)ctx.dialect())) {
            ctx.visit(DSL.function(Names.N_BITNOT, this.getDataType(), this.field));
        } else if (this.operator == ExpressionOperator.BIT_NOT && family == SQLDialect.FIREBIRD) {
            ctx.visit(DSL.function(Names.N_BIN_NOT, this.getDataType(), this.field));
        } else {
            ctx.sql(this.operator.toSQL()).sql('(').visit(this.field).sql(')');
        }
    }
}

