/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class Ltrim
extends AbstractField<String> {
    private final Field<String> string;
    private final Field<String> characters;

    Ltrim(Field<String> string) {
        super(Names.N_LTRIM, Tools.allNotNull(SQLDataType.VARCHAR, string));
        this.string = Tools.nullSafeNotNull(string, SQLDataType.VARCHAR);
        this.characters = null;
    }

    Ltrim(Field<String> string, Field<String> characters) {
        super(Names.N_LTRIM, Tools.allNotNull(SQLDataType.VARCHAR, string, characters));
        this.string = Tools.nullSafeNotNull(string, SQLDataType.VARCHAR);
        this.characters = Tools.nullSafeNotNull(characters, SQLDataType.VARCHAR);
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.characters == null) {
            switch (ctx.family()) {
                case FIREBIRD: {
                    ctx.visit(Names.N_TRIM).sql('(').visit(Keywords.K_LEADING).sql(' ').visit(Keywords.K_FROM).sql(' ').visit(this.string).sql(')');
                    break;
                }
                default: {
                    ctx.visit(DSL.function(Names.N_LTRIM, this.getDataType(), this.string));
                    break;
                }
            }
        } else {
            switch (ctx.family()) {
                case SQLITE: {
                    ctx.visit(DSL.function(Names.N_LTRIM, this.getDataType(), this.string, this.characters));
                    break;
                }
                default: {
                    ctx.visit(Names.N_TRIM).sql('(').visit(Keywords.K_LEADING).sql(' ').visit(this.characters).sql(' ').visit(Keywords.K_FROM).sql(' ').visit(this.string).sql(')');
                }
            }
        }
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof Ltrim) {
            return StringUtils.equals(this.string, ((Ltrim)that).string) && StringUtils.equals(this.characters, ((Ltrim)that).characters);
        }
        return super.equals(that);
    }
}

