/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Domain;
import org.jooq.DropDomainCascadeStep;
import org.jooq.DropDomainFinalStep;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractDDLQuery;
import org.jooq.impl.Cascade;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class DropDomainImpl
extends AbstractDDLQuery
implements DropDomainCascadeStep,
DropDomainFinalStep {
    private final Domain<?> domain;
    private final boolean dropDomainIfExists;
    private Cascade cascade;
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.FIREBIRD);

    DropDomainImpl(Configuration configuration, Domain<?> domain, boolean dropDomainIfExists) {
        this(configuration, domain, dropDomainIfExists, null);
    }

    DropDomainImpl(Configuration configuration, Domain<?> domain, boolean dropDomainIfExists, Cascade cascade) {
        super(configuration);
        this.domain = domain;
        this.dropDomainIfExists = dropDomainIfExists;
        this.cascade = cascade;
    }

    final Domain<?> $domain() {
        return this.domain;
    }

    final boolean $dropDomainIfExists() {
        return this.dropDomainIfExists;
    }

    final Cascade $cascade() {
        return this.cascade;
    }

    @Override
    public final DropDomainImpl cascade() {
        this.cascade = Cascade.CASCADE;
        return this;
    }

    @Override
    public final DropDomainImpl restrict() {
        this.cascade = Cascade.RESTRICT;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.dropDomainIfExists && !this.supportsIfExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.DROP_DOMAIN, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        switch (ctx.family()) {
            default: 
        }
        ctx.visit(Keywords.K_DROP).sql(' ').visit(Keywords.K_DOMAIN);
        if (this.dropDomainIfExists && this.supportsIfExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
        }
        ctx.sql(' ').visit(this.domain);
        DropDomainImpl.acceptCascade(ctx, this.cascade);
    }
}

