/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Catalog;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DropDatabaseFinalStep;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractDDLQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class DropDatabaseImpl
extends AbstractDDLQuery
implements DropDatabaseFinalStep {
    private final Catalog database;
    private final boolean dropDatabaseIfExists;
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD);

    DropDatabaseImpl(Configuration configuration, Catalog database, boolean dropDatabaseIfExists) {
        super(configuration);
        this.database = database;
        this.dropDatabaseIfExists = dropDatabaseIfExists;
    }

    final Catalog $database() {
        return this.database;
    }

    final boolean $dropDatabaseIfExists() {
        return this.dropDatabaseIfExists;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.dropDatabaseIfExists && !this.supportsIfExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.DROP_DATABASE, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private void accept0(Context<?> ctx) {
        ctx.visit(Keywords.K_DROP).sql(' ').visit(Keywords.K_DATABASE);
        if (this.dropDatabaseIfExists && this.supportsIfExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
        }
        ctx.sql(' ').visit(this.database);
    }
}

