/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jooq.Configuration;
import org.jooq.Parser;
import org.jooq.Queries;
import org.jooq.RenderContext;
import org.jooq.conf.ParamType;
import org.jooq.impl.DefaultDiagnosticsContext;
import org.jooq.impl.DiagnosticsListeners;
import org.jooq.impl.DiagnosticsStatement;
import org.jooq.impl.ParserException;
import org.jooq.tools.jdbc.DefaultConnection;

final class DiagnosticsConnection
extends DefaultConnection {
    static final int LRU_SIZE_GLOBAL = 50000;
    static final int LRU_SIZE_LOCAL = 500;
    static final int DUP_SIZE = 500;
    static final Map<String, Set<String>> DUPLICATE_SQL = Collections.synchronizedMap(new LRU(50000));
    final Map<String, List<String>> repeatedSQL = new LRU<List<String>>(500);
    final Configuration configuration;
    final RenderContext normalisingRenderer;
    final Parser parser;
    final DiagnosticsListeners listeners;

    DiagnosticsConnection(Configuration configuration) {
        super(configuration.connectionProvider().acquire());
        this.configuration = configuration;
        this.normalisingRenderer = configuration.deriveSettings(s2 -> s2.withParamType(ParamType.FORCE_INDEXED).withInListPadding(true).withInListPadBase(16)).dsl().renderContext();
        this.parser = configuration.dsl().parser();
        this.listeners = DiagnosticsListeners.get(configuration);
    }

    @Override
    public final Statement createStatement() throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().createStatement());
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().createStatement(resultSetType, resultSetConcurrency));
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareStatement(this.parse(sql)));
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareStatement(this.parse(sql), resultSetType, resultSetConcurrency));
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareStatement(this.parse(sql), resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareStatement(this.parse(sql), autoGeneratedKeys));
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareStatement(this.parse(sql), columnIndexes));
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareStatement(this.parse(sql), columnNames));
    }

    @Override
    public final CallableStatement prepareCall(String sql) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareCall(this.parse(sql)));
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareCall(this.parse(sql), resultSetType, resultSetConcurrency));
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareCall(this.parse(sql), resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public final void close() throws SQLException {
        this.repeatedSQL.clear();
        this.configuration.connectionProvider().release(this.getDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String parse(String sql) {
        List<String> repetitions;
        Set<String> duplicates;
        String normalised;
        try {
            Queries queries = this.parser.parse(sql);
            normalised = this.normalisingRenderer.render(queries);
        }
        catch (ParserException ignore) {
            normalised = sql;
        }
        Map<String, Set<String>> map = DUPLICATE_SQL;
        synchronized (map) {
            duplicates = this.duplicates(DUPLICATE_SQL, sql, normalised);
        }
        if (duplicates != null) {
            this.listeners.duplicateStatements(new DefaultDiagnosticsContext(sql, normalised, duplicates, null));
        }
        if ((repetitions = this.repetitions(this.repeatedSQL, sql, normalised)) != null) {
            this.listeners.repeatedStatements(new DefaultDiagnosticsContext(sql, normalised, null, repetitions));
        }
        return sql;
    }

    private Set<String> duplicates(Map<String, Set<String>> map, String sql, String normalised) {
        Set v = map.computeIfAbsent(normalised, k -> new HashSet());
        if (v.size() >= 500 || v.add(sql) && v.size() > 1) {
            return v;
        }
        return null;
    }

    private List<String> repetitions(Map<String, List<String>> map, String sql, String normalised) {
        List v = map.computeIfAbsent(normalised, k -> new ArrayList());
        if (v.size() >= 500 || v.add(sql) && v.size() > 1) {
            return v;
        }
        return null;
    }

    static class LRU<V>
    extends LinkedHashMap<String, V> {
        private final int size;

        LRU(int size) {
            super(size + 1, 1.0f, true);
            this.size = size;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, V> eldest) {
            return this.size() > this.size;
        }
    }
}

