/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigDecimal;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class Degrees
extends AbstractField<BigDecimal> {
    private final Field<? extends Number> radians;

    Degrees(Field<? extends Number> radians2) {
        super(Names.N_DEGREES, Tools.allNotNull(SQLDataType.NUMERIC, radians2));
        this.radians = Tools.nullSafeNotNull(radians2, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: 
            case SQLITE: {
                ctx.visit(Internal.idiv(Internal.imul(Tools.castIfNeeded(this.radians, BigDecimal.class), DSL.inline(180)), DSL.pi()));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_DEGREES, this.getDataType(), this.radians));
            }
        }
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof Degrees) {
            return StringUtils.equals(this.radians, ((Degrees)that).radians);
        }
        return super.equals(that);
    }
}

