/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.CaseConditionStep;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Names;
import org.jooq.impl.Tools;

final class Decode<T, Z>
extends AbstractField<Z> {
    private static final Set<SQLDialect> EMULATE_DISTINCT = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE);
    private final Field<T> field;
    private final Field<T> search;
    private final Field<Z> result;
    private final Field<?>[] more;

    public Decode(Field<T> field, Field<T> search, Field<Z> result, Field<?>[] more) {
        super(Names.N_DECODE, result.getDataType());
        this.field = field;
        this.search = search;
        this.result = result;
        this.more = more;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (EMULATE_DISTINCT.contains((Object)ctx.dialect())) {
            CaseConditionStep<Z> when = DSL.choose().when(this.field.isNotDistinctFrom(this.search), this.result);
            int i = 0;
            while (i + 1 < this.more.length) {
                when = when.when(this.field.isNotDistinctFrom(this.more[i]), this.more[i + 1]);
                i += 2;
            }
            if (this.more.length % 2 == 0) {
                ctx.visit(when);
            } else {
                ctx.visit(when.otherwise(this.more[this.more.length - 1]));
            }
        } else {
            ctx.visit(DSL.function(Names.N_DECODE, this.getDataType(), Tools.combine(this.field, this.search, this.result, this.more)));
        }
    }
}

