/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Condition;
import org.jooq.Context;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

final class ConditionAsField
extends AbstractField<Boolean> {
    final Condition condition;

    ConditionAsField(Condition condition) {
        super(DSL.name(condition.toString()), SQLDataType.BOOLEAN);
        this.condition = condition;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case CUBRID: 
            case FIREBIRD: {
                this.acceptCase(ctx);
                break;
            }
            default: {
                ctx.sql('(').visit(this.condition).sql(')');
            }
        }
    }

    private final void acceptCase(Context<?> ctx) {
        if (this.condition instanceof AbstractCondition && !((AbstractCondition)this.condition).isNullable()) {
            ctx.visit(DSL.when(this.condition, DSL.inline(true)).else_(DSL.inline(false)));
        } else {
            ctx.visit(DSL.when(this.condition, DSL.inline(true)).when(DSL.not(this.condition), DSL.inline(false)));
        }
    }
}

