/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.CommonTableExpression;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.ResultQuery;
import org.jooq.SQLDialect;
import org.jooq.TableOptions;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.DSL;
import org.jooq.impl.DerivedColumnListImpl;
import org.jooq.impl.FieldsImpl;
import org.jooq.impl.FieldsTrait;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class CommonTableExpressionImpl<R extends Record>
extends AbstractTable<R>
implements CommonTableExpression<R> {
    private static final Set<SQLDialect> SUPPORT_MATERIALIZED = SQLDialect.supportedBy(SQLDialect.POSTGRES);
    private final DerivedColumnListImpl name;
    private final ResultQuery<R> query;
    private final FieldsImpl<R> fields;
    private final Boolean materialized;

    CommonTableExpressionImpl(DerivedColumnListImpl name, ResultQuery<R> query, Boolean materialized) {
        super(TableOptions.expression(), name.name);
        this.name = name;
        this.query = query;
        this.fields = this.fields1();
        this.materialized = materialized;
    }

    @Override
    public final Class<? extends R> getRecordType() {
        return this.query.getRecordType();
    }

    @Override
    public final boolean declaresCTE() {
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (ctx.declareCTE()) {
            ResultQuery<R> s2 = this.query;
            ctx.visit(this.name);
            ctx.sql(' ').visit(Keywords.K_AS).sql(' ');
            Object previous = null;
            if (this.materialized != null && SUPPORT_MATERIALIZED.contains((Object)ctx.dialect())) {
                if (this.materialized.booleanValue()) {
                    ctx.visit(Keywords.K_MATERIALIZED).sql(' ');
                } else {
                    ctx.visit(Keywords.K_NOT).sql(' ').visit(Keywords.K_MATERIALIZED).sql(' ');
                }
            }
            Tools.visitSubquery(ctx, s2);
        } else {
            ctx.visit(this.name.name);
        }
    }

    @Override
    final FieldsImpl<R> fields0() {
        return this.fields;
    }

    final FieldsImpl<R> fields1() {
        Field<?>[] s2 = FieldsImpl.fieldsRow0((FieldsTrait)((Object)this.query)).fields();
        Field[] f = new Field[Tools.degree(this.query)];
        for (int i = 0; i < f.length; ++i) {
            f[i] = DSL.field(DSL.name(this.name.name, this.name.fieldNames.length > 0 ? this.name.fieldNames[i] : s2[i].getUnqualifiedName()), f.length == 1 ? Tools.scalarType(this.query) : s2[i].getDataType());
        }
        return new FieldsImpl(f);
    }
}

