/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class Ceil<T extends Number>
extends AbstractField<T> {
    private final Field<T> value;

    Ceil(Field<T> value) {
        super(Names.N_CEIL, Tools.allNotNull(Tools.dataType(SQLDataType.INTEGER, value, false), value));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case SQLITE: {
                ctx.sql('(').visit(this.value.cast(SQLDataType.BIGINT)).sql(" + (").visit(this.value).sql(" > ").visit(this.value.cast(SQLDataType.BIGINT)).sql("))");
                break;
            }
            case H2: {
                ctx.visit(DSL.function(Names.N_CEILING, this.getDataType(), this.value));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_CEIL, this.getDataType(), this.value));
            }
        }
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof Ceil) {
            return StringUtils.equals(this.value, ((Ceil)that).value);
        }
        return super.equals(that);
    }
}

