/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.AlterViewFinalStep;
import org.jooq.AlterViewStep;
import org.jooq.Clause;
import org.jooq.Comment;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.AbstractDDLQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class AlterViewImpl
extends AbstractDDLQuery
implements AlterViewStep,
AlterViewFinalStep {
    private final Table<?> view;
    private final boolean alterViewIfExists;
    private Comment comment;
    private Table<?> renameTo;
    private static final Clause[] CLAUSES = new Clause[]{Clause.ALTER_VIEW};
    private static final Set<SQLDialect> SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD);

    AlterViewImpl(Configuration configuration, Table<?> view, boolean alterViewIfExists) {
        this(configuration, view, alterViewIfExists, null, null);
    }

    AlterViewImpl(Configuration configuration, Table<?> view, boolean alterViewIfExists, Comment comment, Table<?> renameTo) {
        super(configuration);
        this.view = view;
        this.alterViewIfExists = alterViewIfExists;
        this.comment = comment;
        this.renameTo = renameTo;
    }

    final Table<?> $view() {
        return this.view;
    }

    final boolean $alterViewIfExists() {
        return this.alterViewIfExists;
    }

    final Comment $comment() {
        return this.comment;
    }

    final Table<?> $renameTo() {
        return this.renameTo;
    }

    @Override
    public final AlterViewImpl comment(String comment) {
        return this.comment(DSL.comment(comment));
    }

    @Override
    public final AlterViewImpl comment(Comment comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public final AlterViewImpl renameTo(String renameTo) {
        return this.renameTo((Table)DSL.table(DSL.name(renameTo)));
    }

    @Override
    public final AlterViewImpl renameTo(Name renameTo) {
        return this.renameTo((Table)DSL.table(renameTo));
    }

    @Override
    public final AlterViewImpl renameTo(Table<?> renameTo) {
        this.renameTo = renameTo;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.alterViewIfExists && !this.supportsIfExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.ALTER_VIEW, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        if (this.comment != null) {
            ctx.visit(DSL.commentOnView(this.view).is(this.comment));
            return;
        }
        this.accept1(ctx);
    }

    private final void accept1(Context<?> ctx) {
        ctx.start(Clause.ALTER_VIEW_VIEW).visit(Keywords.K_ALTER).sql(' ').visit(ctx.family() == SQLDialect.HSQLDB ? Keywords.K_TABLE : Keywords.K_VIEW);
        if (this.alterViewIfExists && this.supportsIfExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
        }
        ctx.sql(' ').visit(this.view).end(Clause.ALTER_VIEW_VIEW).formatIndentStart().formatSeparator();
        if (this.renameTo != null) {
            ctx.start(Clause.ALTER_VIEW_RENAME).visit(Keywords.K_RENAME_TO).sql(' ').qualify(false, c -> c.visit(this.renameTo)).end(Clause.ALTER_VIEW_RENAME);
        }
        ctx.formatIndentEnd();
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

