/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.exception;

import io.r2dbc.spi.R2dbcException;
import java.sql.SQLException;
import org.jooq.exception.ExceptionTools;
import org.jooq.exception.SQLStateClass;
import org.jooq.exception.SQLStateSubclass;

public class DataAccessException
extends RuntimeException {
    public DataAccessException(String message) {
        super(message);
    }

    public DataAccessException(String message, Throwable cause) {
        super(message, cause);
    }

    public String sqlState() {
        SQLException s2 = this.getCause(SQLException.class);
        if (s2 != null) {
            return s2.getSQLState();
        }
        R2dbcException r = this.getCause(R2dbcException.class);
        if (r != null) {
            return r.getSqlState();
        }
        return "00000";
    }

    public SQLStateClass sqlStateClass() {
        R2dbcException r;
        SQLException s2 = this.getCause(SQLException.class);
        if (s2 != null) {
            if (s2.getSQLState() != null) {
                return SQLStateClass.fromCode(s2.getSQLState());
            }
            if (s2.getSQLState() == null && "org.sqlite.SQLiteException".equals(s2.getClass().getName())) {
                return SQLStateClass.fromSQLiteVendorCode(s2.getErrorCode());
            }
        }
        if ((r = this.getCause(R2dbcException.class)) != null && r.getSqlState() != null) {
            return SQLStateClass.fromCode(r.getSqlState());
        }
        return SQLStateClass.NONE;
    }

    public SQLStateSubclass sqlStateSubclass() {
        return SQLStateSubclass.fromCode(this.sqlState());
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return super.getStackTrace();
    }

    public <T extends Throwable> T getCause(Class<? extends T> type) {
        return ExceptionTools.getCause(this, type);
    }
}

