/*
 * Decompiled with CFR 0.152.
 */
package org.jooq;

import org.jooq.tools.StringUtils;

public final class XMLFormat {
    public static final XMLFormat DEFAULT_FOR_RESULTS = new XMLFormat();
    public static final XMLFormat DEFAULT_FOR_RECORDS = new XMLFormat().header(false).xmlns(false);
    final boolean xmlns;
    final boolean format;
    final String newline;
    final int globalIndent;
    final int indent;
    final String[] indented;
    final boolean header;
    final RecordFormat recordFormat;
    final boolean quoteNested;

    public XMLFormat() {
        this(true, false, "\n", 0, 2, null, true, RecordFormat.VALUE_ELEMENTS_WITH_FIELD_ATTRIBUTE, false);
    }

    private XMLFormat(boolean xmlns, boolean format, String newline, int globalIndent, int indent, String[] indented, boolean header, RecordFormat recordFormat, boolean quoteNested) {
        String[] stringArray;
        this.xmlns = xmlns;
        this.format = format;
        this.newline = newline;
        this.globalIndent = globalIndent;
        this.indent = indent;
        if (indented != null) {
            stringArray = indented;
        } else {
            String[] stringArray2 = new String[4];
            stringArray2[0] = "";
            stringArray2[1] = format ? StringUtils.rightPad("", indent * 1) : "";
            stringArray2[2] = format ? StringUtils.rightPad("", indent * 2) : "";
            stringArray = stringArray2;
            stringArray2[3] = format ? StringUtils.rightPad("", indent * 3) : "";
        }
        this.indented = stringArray;
        this.header = header;
        this.recordFormat = recordFormat;
        this.quoteNested = quoteNested;
    }

    public final XMLFormat xmlns(boolean newXmlns) {
        return new XMLFormat(newXmlns, this.format, this.newline, this.globalIndent, this.indent, this.indented, this.header, this.recordFormat, this.quoteNested);
    }

    public final boolean xmlns() {
        return this.xmlns;
    }

    public final XMLFormat format(boolean newFormat) {
        return new XMLFormat(this.xmlns, newFormat, this.newline, this.globalIndent, this.indent, null, this.header, this.recordFormat, this.quoteNested);
    }

    public final boolean format() {
        return this.format;
    }

    public final XMLFormat newline(String newNewline) {
        return new XMLFormat(this.xmlns, this.format, newNewline, this.globalIndent, this.indent, this.indented, this.header, this.recordFormat, this.quoteNested);
    }

    public final String newline() {
        return this.format ? this.newline : "";
    }

    public final XMLFormat globalIndent(int newGlobalIndent) {
        return new XMLFormat(this.xmlns, this.format, this.newline, newGlobalIndent, this.indent, null, this.header, this.recordFormat, this.quoteNested);
    }

    public final int globalIndent() {
        return this.globalIndent;
    }

    public final XMLFormat indent(int newIndent) {
        return new XMLFormat(this.xmlns, this.format, this.newline, this.globalIndent, newIndent, null, this.header, this.recordFormat, this.quoteNested);
    }

    public final int indent() {
        return this.indent;
    }

    public final String indentString(int level) {
        int i = level + this.globalIndent / this.indent;
        if (i < this.indented.length) {
            return this.indented[i];
        }
        if (this.format) {
            return StringUtils.rightPad("", this.globalIndent + this.indent * level);
        }
        return "";
    }

    public final XMLFormat header(boolean newHeader) {
        return new XMLFormat(this.xmlns, this.format, this.newline, this.globalIndent, this.indent, this.indented, newHeader, this.recordFormat, this.quoteNested);
    }

    public final boolean header() {
        return this.header;
    }

    public final XMLFormat recordFormat(RecordFormat newRecordFormat) {
        return new XMLFormat(this.xmlns, this.format, this.newline, this.globalIndent, this.indent, this.indented, this.header, newRecordFormat, this.quoteNested);
    }

    public final RecordFormat recordFormat() {
        return this.recordFormat;
    }

    public final XMLFormat quoteNested(boolean newQuoteNested) {
        return new XMLFormat(this.xmlns, this.format, this.newline, this.globalIndent, this.indent, this.indented, this.header, this.recordFormat, newQuoteNested);
    }

    public final boolean quoteNested() {
        return this.quoteNested;
    }

    public static enum RecordFormat {
        VALUE_ELEMENTS_WITH_FIELD_ATTRIBUTE,
        VALUE_ELEMENTS,
        COLUMN_NAME_ELEMENTS;

    }
}

