/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.parser.bean;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.List;
import org.jooby.internal.parser.bean.BeanPath;

class BeanComplexPath
implements BeanPath {
    private List<BeanPath> chain;
    private BeanPath setter;
    private String path;

    public BeanComplexPath(List<BeanPath> chain, BeanPath setter, String path) {
        this.chain = chain;
        this.setter = setter;
        this.path = path;
    }

    @Override
    public void set(Object bean, Object ... args) throws Throwable {
        Object target = this.get(bean, new Object[0]);
        this.setter.set(target, args);
    }

    @Override
    public Object get(Object bean, Object ... args) throws Throwable {
        Object target = bean;
        for (BeanPath path : this.chain) {
            Object next = path.get(target, args);
            if (next == null) {
                next = ((Class)path.settype()).newInstance();
                path.set(target, next);
            }
            target = next;
        }
        return target;
    }

    @Override
    public AnnotatedElement setelem() {
        return this.setter.setelem();
    }

    @Override
    public Type settype() {
        return this.setter.settype();
    }

    @Override
    public Type type() {
        return this.setter.type();
    }

    public String toString() {
        return this.path;
    }
}

