/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.parser;

import com.google.inject.TypeLiteral;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import org.jooby.Parser;

public class StaticMethodParser
implements Parser {
    private final String methodName;

    public StaticMethodParser(String methodName) {
        this.methodName = Objects.requireNonNull(methodName, "A method's name is required.");
    }

    public boolean matches(TypeLiteral<?> toType) {
        try {
            return this.method(toType.getRawType()) != null;
        }
        catch (NoSuchMethodException x) {
            return false;
        }
    }

    @Override
    public Object parse(TypeLiteral<?> type, Parser.Context ctx) throws Exception {
        return ctx.param(params -> {
            try {
                return this.method(type.getRawType()).invoke(null, params.get(0));
            }
            catch (NoSuchMethodException x) {
                return ctx.next();
            }
        });
    }

    public Object parse(TypeLiteral<?> type, Object value) throws Exception {
        return this.method(type.getRawType()).invoke(null, value);
    }

    private Method method(Class<?> rawType) throws NoSuchMethodException {
        Method method = rawType.getDeclaredMethod(this.methodName, String.class);
        int mods = method.getModifiers();
        return Modifier.isPublic(mods) && Modifier.isStatic(mods) ? method : null;
    }

    public String toString() {
        return this.methodName + "(String)";
    }
}

