/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.parser;

import com.google.inject.TypeLiteral;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.jooby.Parser;

public class DateParser
implements Parser {
    private String dateFormat;

    public DateParser(String dateFormat) {
        this.dateFormat = Objects.requireNonNull(dateFormat, "A dateFormat is required.");
    }

    @Override
    public Object parse(TypeLiteral<?> type, Parser.Context ctx) throws Throwable {
        if (type.getRawType() == Date.class) {
            return ctx.param(values -> DateParser.parse(this.dateFormat, (String)NOT_EMPTY.apply(values.get(0)))).body(body -> DateParser.parse(this.dateFormat, (String)NOT_EMPTY.apply(body.text())));
        }
        return ctx.next();
    }

    public String toString() {
        return "Date";
    }

    private static Date parse(String dateFormat, String value) throws Throwable {
        try {
            return new Date(Long.parseLong(value));
        }
        catch (NumberFormatException ex) {
            return new SimpleDateFormat(dateFormat).parse(value);
        }
    }
}

