/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.parser;

import com.google.common.primitives.Primitives;
import com.google.common.reflect.Reflection;
import com.google.inject.TypeLiteral;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jooby.Err;
import org.jooby.Mutant;
import org.jooby.Parser;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.funzy.Try;
import org.jooby.internal.ParameterNameProvider;
import org.jooby.internal.mvc.RequestParam;
import org.jooby.internal.parser.bean.BeanPlan;

public class BeanParser
implements Parser {
    private Function<? super Throwable, Try.Value<? extends Object>> MISSING = x -> x instanceof Err.Missing ? Try.success(null) : Try.failure(x);
    private Function<? super Throwable, Try.Value<? extends Object>> RETHROW = Try::failure;
    private Function<? super Throwable, Try.Value<? extends Object>> recoverMissing;
    private final Map<TypeLiteral, BeanPlan> forms;

    public BeanParser(boolean allowNulls) {
        this.recoverMissing = allowNulls ? this.MISSING : this.RETHROW;
        this.forms = new ConcurrentHashMap<TypeLiteral, BeanPlan>();
    }

    @Override
    public Object parse(TypeLiteral<?> type, Parser.Context ctx) throws Throwable {
        Class<?> beanType = type.getRawType();
        if (Primitives.isWrapperType(Primitives.wrap(beanType)) || CharSequence.class.isAssignableFrom(beanType)) {
            return ctx.next();
        }
        return ctx.ifparams(map -> {
            Object bean = List.class.isAssignableFrom(beanType) ? this.newBean(ctx.require(Request.class), ctx.require(Response.class), ctx.require(Route.Chain.class), (Map<String, Mutant>)map, type) : (beanType.isInterface() ? this.newBeanInterface(ctx.require(Request.class), ctx.require(Response.class), ctx.require(Route.Chain.class), beanType) : this.newBean(ctx.require(Request.class), ctx.require(Response.class), ctx.require(Route.Chain.class), (Map<String, Mutant>)map, type));
            return bean;
        });
    }

    public String toString() {
        return "bean";
    }

    private Object newBean(Request req, Response rsp, Route.Chain chain, Map<String, Mutant> params, TypeLiteral type) throws Throwable {
        BeanPlan form = this.forms.get(type);
        if (form == null) {
            form = new BeanPlan(req.require(ParameterNameProvider.class), type);
            this.forms.put(type, form);
        }
        return form.newBean(p -> this.value((RequestParam)p, req, rsp, chain), params.keySet());
    }

    private Object newBeanInterface(Request req, Response rsp, Route.Chain chain, Class<?> beanType) {
        return Reflection.newProxy(beanType, (proxy, method, args) -> {
            StringBuilder name = new StringBuilder(method.getName().replace("get", "").replace("is", ""));
            name.setCharAt(0, Character.toLowerCase(name.charAt(0)));
            return this.value(new RequestParam(method, name.toString(), method.getGenericReturnType()), req, rsp, chain);
        });
    }

    private Object value(RequestParam param, Request req, Response rsp, Route.Chain chain) throws Throwable {
        return Try.apply(() -> param.value(req, rsp, chain)).recover(x -> this.recoverMissing.apply((Throwable)x).get()).get();
    }
}

